<?php
/**
 * The Header for our theme.
 *
 * @package Betheme
 * @author Muffin group
 * @link http://muffingroup.com
 */
?><!DOCTYPE html>
<?php 
	if( $_GET && key_exists('mfn-rtl', $_GET) ):
		echo '<html class="no-js" lang="ar" dir="rtl">';
	else:
?>
<html class="no-js<?php echo mfn_user_os(); ?>" <?php language_attributes(); ?><?php mfn_tag_schema(); ?>>
<?php endif; ?>

<!-- head -->
<head>

<!-- meta -->
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<?php 
	if( mfn_opts_get('responsive') ){
		if( mfn_opts_get('responsive-zoom') ){
			echo '<meta name="viewport" content="width=device-width, initial-scale=1" />';
		} else {
			echo '<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />';
		}
		 
	}
?>

<?php do_action('wp_seo'); ?>

<link rel="shortcut icon" href="<?php mfn_opts_show( 'favicon-img', THEME_URI .'/images/favicon.ico' ); ?>" />	
<?php if( mfn_opts_get('apple-touch-icon') ): ?>
<link rel="apple-touch-icon" href="<?php mfn_opts_show( 'apple-touch-icon' ); ?>" />
<?php endif; ?>	

<!-- wp_head() -->
<?php wp_head(); ?>
<link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,300i,400,400i,600,600i,700,700i,900,900i" rel="stylesheet">
      <meta name="viewport" content="initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
      <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" type="text/css">
      <link rel="stylesheet"  href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css">
      <link href='https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css' rel='stylesheet' type='text/css'>
      <link rel="shortcut icon" href="https://togglebytes.com/accets/img/favicon.png" type="image/png"><!--Favicon-->
	  <link rel="icon" href="https://togglebytes.com/accets/img/favicon.png" type="image/png"><!--Favicon-->
    <script src="https://code.jquery.com/jquery-1.11.1.min.js" integrity="sha256-VAvG3sHdS5LqTT+5A/aeq/bZGa/Uj04xKxY8KM/w9EE=" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-cookie/1.4.1/jquery.cookie.js" ></script>
      <!-- <script src="https://togglebytes.com/accets/js/1.11.1.jquery.min.js"></script> -->
      <script src="https://stackpath.bootstrapcdn.com/bootstrap/3.3.4/js/bootstrap.min.js"></script>
      <link href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.4/css/bootstrap.min.css" rel="stylesheet"/>
      <link rel="stylesheet" type="text/css" href="https://togglebytes.com/accets/css/slick.css"/>
      <link rel="stylesheet" type="text/css" href="https://togglebytes.com/accets/css/slick-theme.css"/>
      <link rel="stylesheet" href="https://togglebytes.com/accets/css/bigmenu.css" type="text/css">
      <link rel="stylesheet" href="https://togglebytes.com/accets/css/style.css" type="text/css">
      <link rel="stylesheet" href="https://togglebytes.com/accets/css/responsive.css" type="text/css">

	<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=UA-146124260-1"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'UA-146124260-1');
</script>

<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-KM2MQVD');</script>
<!-- End Google Tag Manager -->
</head>

<!-- body -->
<body <?php body_class(); ?>>
	
	<?php do_action( 'mfn_hook_top' ); ?>

	<?php get_template_part( 'includes/header', 'sliding-area' ); ?>
	
	<?php if( mfn_header_style( true ) == 'header-creative' ) get_template_part( 'includes/header', 'creative' ); ?>
	<div class="header_main header_disblck" id="myHeader">
         <div class="header_bottom_line"><img src="https://togglebytes.com/accets/img/header_bottom_line.png"></div>
         <div class="container">
            <div class="header_logo"><a href="https://togglebytes.com"><img src="https://togglebytes.com/accets/img/logo.png"></a></div>
            <div class="menu">
               <a href="#" class="menu-mobile"></a><ul id="nav">
                  <li><a href="https://togglebytes.com" class="homesacitve">HOME</a></li>
                  <li><a href="https://togglebytes.com/about" class="header_about">ABOUT</a></li>
                  <li class="menu-dropdown-icon">
                     <a href="javascript:;" class="header_whattodo">What WE DO</a>
                     <ul>
                        <li>
                           <a href="https://togglebytes.com/services" class="wwdsmm">Services</a>
                           <ul>
                              <li><a href="https://togglebytes.com/cloud-computing">Cloud Computing</a></li>
                              <li><a href="https://togglebytes.com/mobile-app-development">Mobile Application</a></li>
                              <li><a href="https://togglebytes.com/big-data-analytics">Analytics &amp; Big Data</a></li>
                              <li><a href="https://togglebytes.com/qa-testing">QA &amp; Testing</a></li>
                           </ul>
                        </li>
                        <li>
                           <a href="#"></a>
                           <ul>
                              <li><a href="https://togglebytes.com/software-consulting">Software Consulting</a></li>
                              <li><a href="https://togglebytes.com/web-development">Web Development</a></li>
                           </ul>
                        </li>
                        <li>
                           <a href="#">Enterprise Solutions</a>
                           <ul>
                              <li><a href="https://togglebytes.com/enterprise-crm">CRM</a></li>
                              <li><a href="https://togglebytes.com/enterprise-cms">CMS</a></li>
                              <li><a href="https://togglebytes.com/enterprise-ecommerce-solutions">Ecommerce Solutions</a></li>
                              <li><a href="https://togglebytes.com/enterprise-resource-planning">ERP</a></li>
                           </ul>
                        </li>
                        <div style="clear:both;"></div>
                        <hr class="wwdmenuline">
                        <div class="row wwd">
                           <div class="col-sm-8">
                              <h3>Engagement Models</h3>
                              <p><b>Projects: </b> Fixed Cost, Time &amp; Material Model</p>
                              <p><b>Team Aligmentation: </b> Resource as a Service (Offshore, Onsite &amp; Hybrid), ODC / BOT</p>
                              <p><b>Product Engineering: </b> Consulting &amp; Planning, Complete Product Engeering</p>
                           </div>
                           <div class="col-sm-4">
                              <h4><a href="https://togglebytes.com/enterprise-digital-transformation">ENTERPRISE <br>DIGITAL TRANSFORMATION</a></h4>
                              <h4><a href="#">END TO END <br>PRODUCT<br> ENGINEERING</a></h4>
                           </div>
                        </div>
                     </ul>
                  </li>
                  <li><a href="https://togglebytes.com/clients-we-work-with" class="header_clients">CLIENTS</a></li>
				<li><a href="https://togglebytes.com/blog/" class="header_clients">Blog</a></li>
                  <li><a href="https://togglebytes.com/contact" class="header_contact">CONTACT</a></li>
               </ul>
            </div>
         </div>
      </div>
	<!-- #Wrapper -->
	<div id="Wrapper">
	
		<?php 
			// Featured Image | Parallax ----------
			$header_style = '';
				
			if( mfn_opts_get( 'img-subheader-attachment' ) == 'parallax' ){
				
				if( mfn_opts_get( 'parallax' ) == 'stellar' ){
					$header_style = ' class="bg-parallax" data-stellar-background-ratio="0.5"';
				} else {
					$header_style = ' class="bg-parallax" data-enllax-ratio="0.3"';
				}
				
			}
		?>
		
		<?php if( mfn_header_style( true ) == 'header-below' ) echo mfn_slider(); ?>

		<!-- #Header_bg -->
		<div id="Header_wrapper" <?php echo $header_style; ?>>
	
			<!-- #Header -->
			<header id="Header">
				<?php if( mfn_header_style( true ) != 'header-creative' ) get_template_part( 'includes/header', 'top-area' ); ?>	
				<?php if( mfn_header_style( true ) != 'header-below' ) echo mfn_slider(); ?>
			</header>
				
			<?php 
				if( ( mfn_opts_get('subheader') != 'all' ) && 
					( ! get_post_meta( mfn_ID(), 'mfn-post-hide-title', true ) ) &&
					( get_post_meta( mfn_ID(), 'mfn-post-template', true ) != 'intro' )	){

					
					$subheader_advanced = mfn_opts_get( 'subheader-advanced' );
					
					$subheader_style = '';
					
					if( mfn_opts_get( 'subheader-padding' ) ){
						$subheader_style .= 'padding:'. mfn_opts_get( 'subheader-padding' ) .';';
					}				
					
					
					if( is_search() ){
						// Page title -------------------------
						
						echo '<div id="Subheader" style="'. $subheader_style .'">';
							echo '<div class="container">';
								echo '<div class="column one">';

									if( trim( $_GET['s'] ) ){
										global $wp_query;
										$total_results = $wp_query->found_posts;
									} else {
										$total_results = 0;
									}

									$translate['search-results'] = mfn_opts_get('translate') ? mfn_opts_get('translate-search-results','results found for:') : __('results found for:','betheme');								
									echo '<h1 class="title">'. $total_results .' '. $translate['search-results'] .' '. esc_html( $_GET['s'] ) .'</h1>';
									
								echo '</div>';
							echo '</div>';
						echo '</div>';
						
						
					} elseif( ! mfn_slider_isset() || ( is_array( $subheader_advanced ) && isset( $subheader_advanced['slider-show'] ) ) ){
						// Page title -------------------------
						
						
						// Subheader | Options
						$subheader_options = mfn_opts_get( 'subheader' );


						if( is_home() && ! get_option( 'page_for_posts' ) && ! mfn_opts_get( 'blog-page' ) ){
							$subheader_show = false;
						} elseif( is_array( $subheader_options ) && isset( $subheader_options[ 'hide-subheader' ] ) ){
							$subheader_show = false;
						} elseif( get_post_meta( mfn_ID(), 'mfn-post-hide-title', true ) ){
							$subheader_show = false;
						} else {
							$subheader_show = true;
						}
						
						
						// title
						if( is_array( $subheader_options ) && isset( $subheader_options[ 'hide-title' ] ) ){
							$title_show = false;
						} else {
							$title_show = true;
						}
						
						
						// breadcrumbs
						if( is_array( $subheader_options ) && isset( $subheader_options[ 'hide-breadcrumbs' ] ) ){
							$breadcrumbs_show = false;
						} else {
							$breadcrumbs_show = true;
						}
						
						if( is_array( $subheader_advanced ) && isset( $subheader_advanced[ 'breadcrumbs-link' ] ) ){
							$breadcrumbs_link = 'has-link';
						} else {
							$breadcrumbs_link = 'no-link';
						}
						
						
						// Subheader | Print
						if( $subheader_show ){
							echo '<div id="Subheader" style="'. $subheader_style .'">';
								echo '<div class="container">';
									echo '<div class="column one">';
										
										// Title
										if( $title_show ){
											$title_tag = mfn_opts_get( 'subheader-title-tag', 'h1' );
											echo '<'. $title_tag .' class="title">'. mfn_page_title() .'</'. $title_tag .'>';
										}
										
										// Breadcrumbs
										if( $breadcrumbs_show ){
											mfn_breadcrumbs( $breadcrumbs_link );
										}
										
									echo '</div>';
								echo '</div>';
							echo '</div>';
						}
						
					}
					
					
				}
			?>
		
		</div>
		
		<?php 
			// Single Post | Template: Intro
			if( get_post_meta( mfn_ID(), 'mfn-post-template', true ) == 'intro' ){
				get_template_part( 'includes/header', 'single-intro' );
			}
		?>
		
		<?php do_action( 'mfn_hook_content_before' );
		
// Omit Closing PHP Tags