<?php
/**
 * The template for displaying the footer.
 *
 * @package Betheme
 * @author Muffin group
 * @link http://muffingroup.com
 */


$back_to_top_class = mfn_opts_get('back-top-top');

if( $back_to_top_class == 'hide' ){
	$back_to_top_position = false;
} elseif( strpos( $back_to_top_class, 'sticky' ) !== false ){
$back_to_top_position = 'body';
} elseif( mfn_opts_get('footer-hide') == 1 ){
	$back_to_top_position = 'footer';
} else {
	$back_to_top_position = 'copyright';
}

?>

<?php do_action( 'mfn_hook_content_after' ); ?>

<!-- #Footer -->		
<footer id="Footer" class="clearfix">
	
	<?php if ( $footer_call_to_action = mfn_opts_get('footer-call-to-action') ): ?>
	<div class="footer_action">
		<div class="container">
			<div class="column one column_column">
				<?php echo do_shortcode( $footer_call_to_action ); ?>
			</div>
		</div>
	</div>
	<?php endif; ?>
	
	<?php 
		$sidebars_count = 0;
		for( $i = 1; $i <= 5; $i++ ){
			if ( is_active_sidebar( 'footer-area-'. $i ) ) $sidebars_count++;
		}
		
		if( $sidebars_count > 0 ){
			
			$footer_style = '';
				
			if( mfn_opts_get( 'footer-padding' ) ){
				$footer_style .= 'padding:'. mfn_opts_get( 'footer-padding' ) .';';
			}
			
			echo '<div class="widgets_wrapper" style="'. $footer_style .'">';
				echo '<div class="container">';
						
					if( $footer_layout = mfn_opts_get( 'footer-layout' ) ){
						// Theme Options

						$footer_layout 	= explode( ';', $footer_layout );
						$footer_cols 	= $footer_layout[0];
		
						for( $i = 1; $i <= $footer_cols; $i++ ){
							if ( is_active_sidebar( 'footer-area-'. $i ) ){
								echo '<div class="column '. $footer_layout[$i] .'">';
									dynamic_sidebar( 'footer-area-'. $i );
								echo '</div>';
							}
						}						
						
					} else {
						// Default - Equal Width
						
						$sidebar_class = '';
						switch( $sidebars_count ){
							case 2: $sidebar_class = 'one-second'; break;
							case 3: $sidebar_class = 'one-third'; break;
							case 4: $sidebar_class = 'one-fourth'; break;
							case 5: $sidebar_class = 'one-fifth'; break;
							default: $sidebar_class = 'one';
						}
						
						for( $i = 1; $i <= 5; $i++ ){
							if ( is_active_sidebar( 'footer-area-'. $i ) ){
								echo '<div class="column '. $sidebar_class .'">';
									dynamic_sidebar( 'footer-area-'. $i );
								echo '</div>';
							}
						}
						
					}
				
				echo '</div>';
			echo '</div>';
		}
	?>


	<?php if( mfn_opts_get('footer-hide') != 1 ): ?>
	
		<div class="footer_copy">
			<div class="container">
				<div class="column one">

					<?php 
						if( $back_to_top_position == 'copyright' ){
							echo '<a id="back_to_top" class="button button_js" href=""><i class="icon-up-open-big"></i></a>';
						}
					?>
					
					<!-- Copyrights -->
					<div class="copyright">
						<?php 
							if( mfn_opts_get('footer-copy') ){
								echo do_shortcode( mfn_opts_get('footer-copy') );
							} else {
								echo '&copy; '. date( 'Y' ) .' '. get_bloginfo( 'name' ) .'. All Rights Reserved. <a target="_blank" rel="nofollow" href="http://muffingroup.com">Muffin group</a>';
							}
						?>
					</div>
					
					<?php 
						if( has_nav_menu( 'social-menu-bottom' ) ){
							mfn_wp_social_menu_bottom();
						} else {
							get_template_part( 'includes/include', 'social' );
						}
					?>
							
				</div>
			</div>
		</div>
	
	<?php endif; ?>
	
	
	<?php 
		if( $back_to_top_position == 'footer' ){
			echo '<a id="back_to_top" class="button button_js in_footer" href=""><i class="icon-up-open-big"></i></a>';
		}
	?>

	
</footer>
<div class="footer">
         <div class="container">
            <div class="row">
               <div class="col-sm-2">
                  <div class="footer_1"><img src="https://togglebytes.com/accets/img/logo.png"></div>
               </div>
               <div class="col-sm-3">
                  <div class="footer_2">
                     <h3>WHAT WE DO</h3>
                     <ul>
                        <li><a href="https://togglebytes.com/mobile-app-development">Mobile Applications</a></li>
                        <li><a href="https://togglebytes.com/cloud-computing">Cloud Computing</a></li>
                        <!-- <li><a href="https://togglebytes.com/">Internet of Things</a></li> -->
                        <!-- <li><a href="https://togglebytes.com/">UX / UI Design</a></li> -->
                        <li><a href="https://togglebytes.com/software-consulting">Software Consulting</a></li>
                        <li><a href="https://togglebytes.com/web-development">Web Development</a></li>
                        <li><a href="https://togglebytes.com/qa-testing">QA &amp; Testing</a></li>
                        <li><a href="https://togglebytes.com/big-data-analytics">Analytics and Big Data</a></li>
                        <!-- <li><a href="https://togglebytes.com/">Internet Marketing</a></li> -->
                     </ul>
                     <h3>TECHNOLOGIES</h3>
                     <div class="row">
                        <div class="col-md-6">
                           <ul>
                              <li>Microsoft</li>
                              <li>Java</li>
                              <li>Frontend</li>
                              <li>Big Data &amp; Consulting</li>
                              <li>Cloud &amp; Infrastructure</li>
                           </ul>
                        </div>
                        <div class="col-md-6">
                           <ul>
                              <li>Open-Source</li>
                              <li>Mobile</li>
                              <li>Databases</li>
                              <li>Internet Of Things</li>
                           </ul>
                        </div>
                     </div>
                  </div>
               </div>
               <div class="col-sm-4">
                  <div class="footer_3">
                     <h3>WE WORK WITH</h3>
                     <ul>
                        <li>Enterprises</li>
                        <li>Agencies</li>
                        <li>Startups</li>
                     </ul>
                     <h3>ENTERPRISE SOLUTIONS</h3>
                     <ul>
                        <li><a href="https://togglebytes.com/enterprise-ecommerce-solutions">Ecommerce Solutions</a></li>
                        <li><a href="https://togglebytes.com/enterprise-cms">CMS</a></li>
                        <li><a href="https://togglebytes.com/enterprise-crm">CRM</a></li>
                        <li><a href="https://togglebytes.com/enterprise-resource-planning">ERP</a></li>
                     </ul>
                     <div class="foter_sub">
                        <p>Subscribe to our email</p>
                        <form method="post" name="subscribe_form">
                          <input type="hidden" name="_token" value="z4tYo7H30icduJBofdV4VEOVEMlOkMt0U6dknrF7">
                          <input type="text" name="email" id="subemail" placeholder="Enter your email address">
                          <input type="button" value="Submit" class="sfs" onclick="getSubscrib()">
                        </form>
                     </div>
                     <span id="err" style="color: red;display: none"></span>
                     <p class="footer_tal">Tel : <a href="tel:9029560949">+91-9029-560-949</a></p>
                  </div>
               </div>
               <div class="col-sm-3">
                  <div class="footer_4">
                     <div class="fr1">
                        <h3>Who We Are</h3>
                        <ul>
                           <li><a href="https://togglebytes.com/about">Overview</a></li>
                           <li><a href="https://togglebytes.com/clients-we-work-with">Clientele</a></li>
                           <li><a href="https://togglebytes.com/about">Global Presence</a></li>
                        </ul>
                     </div>
                     <div class="fr2">
                        <h3>Quick Links</h3>
                        <ul>
                           <li><a href="https://togglebytes.com/enterprise-digital-transformation">Digital Transformation</a></li>
                           <li><a href="https://togglebytes.com/">Product Engineering</a></li>
                        </ul>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="footer_copy">
            <div class="container">
               <div class="row">
                  <div class="col-md-5">
                     <p>Copyright © 2019 Togglebytes Technologies</p>
                  </div>
                  <div class="col-md-4">
                     <!-- <p><a href="">Disclaimer</a>  |  <a href="">Privacy Policy</a>  |  <a href="">Terms of Use</a></p> -->
                  </div>
                <div class="col-md-3">
				    <p class="sn">
				    	<!-- <a href=""><i class="fa fa-share-alt" aria-hidden="true"></i></a> -->
				    	<a href="https://www.facebook.com/togglebytes" target="_blank"><i class="fa fa-facebook" aria-hidden="true"></i></a>
				    	<a href="https://www.linkedin.com/company/togglebytes-technologies" target="_blank"><i class="fa fa-linkedin" aria-hidden="true"></i></a>
				    	<!-- <a href=""><i class="fa fa-twitter" aria-hidden="true"></i></a> </p> -->
				</p></div>
               </div>
            </div>
         </div>
      </div>
</div><!-- #Wrapper -->

<?php 
	// Responsive | Side Slide
	if( mfn_opts_get( 'responsive-mobile-menu' ) ){
		get_template_part( 'includes/header', 'side-slide' );
	}
?>

<?php
	if( $back_to_top_position == 'body' ){
		echo '<a id="back_to_top" class="button button_js '. $back_to_top_class .'" href=""><i class="icon-up-open-big"></i></a>';
	}
?>

<?php if( mfn_opts_get('popup-contact-form') ): ?>
	<div id="popup_contact">
		<a class="button button_js" href="#"><i class="<?php mfn_opts_show( 'popup-contact-form-icon', 'icon-mail-line' ); ?>"></i></a>
		<div class="popup_contact_wrapper">
			<?php echo do_shortcode( mfn_opts_get('popup-contact-form') ); ?>
			<span class="arrow"></span>
		</div>
	</div>
<?php endif; ?>

<?php do_action( 'mfn_hook_bottom' ); ?>
	
<!-- wp_footer() -->
<?php wp_footer(); ?>

</body>
</html>