<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Transactions extends Model
{
    protected $table = 'transactions';
    protected $primaryKey = 'trans_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getTransactions($id){
      $data =  Transactions::where('trans_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getTransactionsView($id){
      $transactions = Transactions::select(array('transactions.*' , 'trader_company.company_name' , 'traders.name' , 'farmers.name' , 'buyers.name'));
      $transactions->where('transactions.trans_id', $id);
      $transactions->leftJoin('trader_company', 'transactions.tc_id', '=','trader_company.tc_id');$transactions->leftJoin('traders', 'transactions.trader', '=','traders.tl_id');$transactions->leftJoin('farmers', 'transactions.farmer', '=','farmers.f_id');$transactions->leftJoin('buyers', 'transactions.buyer', '=','buyers.b_id');
      return $transactions->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("trans_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $transactions = $this->getTransactions($id);
      if($transactions != null){
        
                    if($field=="status"){
                        $status = $transactions->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $transactions->status=$status;
                        $transactions->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $transactions = $this->getTransactions($id);
      if($transactions !=null){
        $img = public_path().'/uploads/'.$transactions->featured_img;
            if($transactions->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $transactions->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getTransactionsData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $transactions = Transactions::select(array('transactions.*' , 'trader_company.company_name' , 'traders.name as trader_name' , 'farmers.name as farmer_name' , 'buyers.name as buyer_name'));
      
      //join
        $transactions->leftJoin('trader_company', 'transactions.tc_id', '=','trader_company.tc_id');$transactions->leftJoin('traders', 'transactions.trader', '=','traders.tl_id');$transactions->leftJoin('farmers', 'transactions.farmer', '=','farmers.f_id');$transactions->leftJoin('buyers', 'transactions.buyer', '=','buyers.b_id');

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $transactions->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $transactions->orderBy($sortBy, $order);
        } else{
          $transactions->orderBy('transactions.trans_id', 'desc');
        }        

        return $transactions->paginate($per_page);
    }

    public function getTransactionsExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $transactions = Transactions::select(array('transactions.*' , 'trader_company.company_name' , 'traders.name' , 'farmers.name' , 'buyers.name'));

      //join
        $transactions->leftJoin('trader_company', 'transactions.tc_id', '=','trader_company.tc_id');$transactions->leftJoin('traders', 'transactions.trader', '=','traders.tl_id');$transactions->leftJoin('farmers', 'transactions.farmer', '=','farmers.f_id');$transactions->leftJoin('buyers', 'transactions.buyer', '=','buyers.b_id');

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $transactions->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $transactions->orderBy($sortBy, $order);
        } else{
          $transactions->orderBy('transactions.trans_id', 'desc');
        }
        return $transactions->get();
    }

    public function updateTransactions($request){
      $id = $request->input('trans_id');
      $transactions = Transactions::getTransactions($id);
      if($transactions !=null){

          $transactions->tc_id = $request->input('tc_id')!="" ? $request->input('tc_id') : "";
	$transactions->trader = $request->input('trader')!="" ? $request->input('trader') : "";
	$transactions->farmer = $request->input('farmer')!="" ? $request->input('farmer') : "";
	$transactions->buyer = $request->input('buyer')!="" ? $request->input('buyer') : "";
	$transactions->amount = $request->input('amount')!="" ? $request->input('amount') : "";
	$transactions->pay_type = $request->input('pay_type')!="" ? $request->input('pay_type') : "";
	$transactions->bank_name = $request->input('bank_name')!="" ? $request->input('bank_name') : "";
	$transactions->cheque_no = $request->input('cheque_no')!="" ? $request->input('cheque_no') : "";
	$transactions->status = $request->input('status')!="" ? $request->input('status') : "";

          $transactions->save();
          return true;
      } else{
        return false;
      }
    }

    public function addTransactions($request){
      $transactions = new Transactions;

        $transactions->tc_id = $request->input('tc_id')!="" ? $request->input('tc_id') : "";
	$transactions->trader = $request->input('trader')!="" ? $request->input('trader') : "";
	$transactions->farmer = $request->input('farmer')!="" ? $request->input('farmer') : "";
	$transactions->buyer = $request->input('buyer')!="" ? $request->input('buyer') : "";
	$transactions->amount = $request->input('amount')!="" ? $request->input('amount') : "";
	$transactions->pay_type = $request->input('pay_type')!="" ? $request->input('pay_type') : "";
	$transactions->bank_name = $request->input('bank_name')!="" ? $request->input('bank_name') : "";
	$transactions->cheque_no = $request->input('cheque_no')!="" ? $request->input('cheque_no') : "";
	$transactions->status = $request->input('status')!="" ? $request->input('status') : "";

        $transactions->save();
        return $transactions->trans_id;
    }
}
