<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Trader_company extends Model
{
    protected $table = 'trader_company';
    protected $primaryKey = 'tc_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getTrader_company($id){
      $data =  Trader_company::where('tc_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getTrader_companyView($id){
      $trader_company = Trader_company::select(array('trader_company.*'));
      $trader_company->where('trader_company.tc_id', $id);
      
      return $trader_company->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("tc_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $trader_company = $this->getTrader_company($id);
      if($trader_company != null){
        
                    if($field=="status"){
                        $status = $trader_company->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $trader_company->status=$status;
                        $trader_company->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $trader_company = $this->getTrader_company($id);
      if($trader_company !=null){
        $img = public_path().'/uploads/'.$trader_company->featured_img;
            if($trader_company->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $trader_company->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getTrader_companyData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $trader_company = Trader_company::select(array('trader_company.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $trader_company->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $trader_company->orderBy($sortBy, $order);
        } else{
          $trader_company->orderBy('trader_company.tc_id', 'desc');
        }        

        return $trader_company->paginate($per_page);
    }

    public function getTrader_companyExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $trader_company = Trader_company::select(array('trader_company.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $trader_company->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $trader_company->orderBy($sortBy, $order);
        } else{
          $trader_company->orderBy('trader_company.tc_id', 'desc');
        }
        return $trader_company->get();
    }

    public function updateTrader_company($request){
      $id = $request->input('tc_id');
      $trader_company = Trader_company::getTrader_company($id);
      if($trader_company !=null){

          $trader_company->company_name = $request->input('company_name')!="" ? $request->input('company_name') : "";
	$trader_company->email = $request->input('email')!="" ? $request->input('email') : "";
	$trader_company->mobile = $request->input('mobile')!="" ? $request->input('mobile') : "";
	// $trader_company->password = $request->input('password')!="" ? $request->input('password') : "";
	$trader_company->status = $request->input('status')!="" ? $request->input('status') : "";

          $trader_company->save();
          return true;
      } else{
        return false;
      }
    }

    public function addTrader_company($request){
      $trader_company = new Trader_company;

        $trader_company->company_name = $request->input('company_name')!="" ? $request->input('company_name') : "";
	$trader_company->email = $request->input('email')!="" ? $request->input('email') : "";
	$trader_company->mobile = $request->input('mobile')!="" ? $request->input('mobile') : "";
	// $trader_company->password = $request->input('password')!="" ? $request->input('password') : "";
	$trader_company->status = $request->input('status')!="" ? $request->input('status') : "";

        $trader_company->save();
        return $trader_company->tc_id;
    }
}
