<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Marqua extends Model
{
    protected $table = 'marqua';
    protected $primaryKey = 'mq_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getMarqua($id){
      $data =  Marqua::where('mq_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getMarquaView($id){
      $marqua = Marqua::select(array('marqua.*' , 'crops.crop'));
      $marqua->where('marqua.mq_id', $id);
      $marqua->leftJoin('crops', 'marqua.crop', '=','crops.crp_id');
      return $marqua->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("mq_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $marqua = $this->getMarqua($id);
      if($marqua != null){
        
                    if($field=="status"){
                        $status = $marqua->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $marqua->status=$status;
                        $marqua->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $marqua = $this->getMarqua($id);
      if($marqua !=null){
        $img = public_path().'/uploads/'.$marqua->featured_img;
            if($marqua->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $marqua->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getMarquaData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $marqua = Marqua::select(array('marqua.*' , 'crops.crop'));
      
      //join
        $marqua->leftJoin('crops', 'marqua.crop', '=','crops.crp_id');

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $marqua->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $marqua->orderBy($sortBy, $order);
        } else{
          $marqua->orderBy('marqua.mq_id', 'desc');
        }        

        return $marqua->paginate($per_page);
    }

    public function getMarquaExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $marqua = Marqua::select(array('marqua.*' , 'crops.crop'));

      //join
        $marqua->leftJoin('crops', 'marqua.crop', '=','crops.crp_id');

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $marqua->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $marqua->orderBy($sortBy, $order);
        } else{
          $marqua->orderBy('marqua.mq_id', 'desc');
        }
        return $marqua->get();
    }

    public function updateMarqua($request){
      $id = $request->input('mq_id');
      $marqua = Marqua::getMarqua($id);
      if($marqua !=null){

          $marqua->crop = $request->input('crop')!="" ? $request->input('crop') : "";
	$marqua->quality = $request->input('quality')!="" ? $request->input('quality') : "";
	$marqua->status = $request->input('status')!="" ? $request->input('status') : "";

          $marqua->save();
          return true;
      } else{
        return false;
      }
    }

    public function addMarqua($request){
      $marqua = new Marqua;

        $marqua->crop = $request->input('crop')!="" ? $request->input('crop') : "";
	$marqua->quality = $request->input('quality')!="" ? $request->input('quality') : "";
	$marqua->status = $request->input('status')!="" ? $request->input('status') : "";

        $marqua->save();
        return $marqua->mq_id;
    }
}
