<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Farmers extends Model
{
    protected $table = 'farmers';
    protected $primaryKey = 'f_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getFarmers($id){
      $data =  Farmers::where('f_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getFarmersView($id){
      $farmers = Farmers::select(array('farmers.*'));
      $farmers->where('farmers.f_id', $id);
      
      return $farmers->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $select_field, $where_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("f_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $farmers = $this->getFarmers($id);
      if($farmers!=null){
        
                    if($field=="status"){
                        $status = $farmers->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $farmers->status=$status;
                        $farmers->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $farmers = $this->getFarmers($id);
      if(count($farmers)){
        $img = public_path().'/uploads/'.$farmers->featured_img;
            if($farmers->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $farmers->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getFarmersData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $farmers = Farmers::select(array('farmers.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $farmers->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $farmers->orderBy($sortBy, $order);
        } else{
          $farmers->orderBy('farmers.f_id', 'desc');
        }        

        return $farmers->paginate($per_page);
    }

    public function getFarmersExport($searchBy, $searchValue, $sortBy, $order){
      $farmers = Farmers::select(array('farmers.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $farmers->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $farmers->orderBy($sortBy, $order);
        } else{
          $farmers->orderBy('farmers.f_id', 'desc');
        }
        return $farmers->get();
    }

    public function updateFarmers($request){
      $id = $request->input('f_id');
      $farmers = Farmers::getFarmers($id);
      if($farmers!=null){

          $farmers->name = $request->input('name')!="" ? $request->input('name') : "";
	$farmers->email = $request->input('email')!="" ? $request->input('email') : "";
	$farmers->mobile = $request->input('mobile')!="" ? $request->input('mobile') : "";
	$farmers->status = $request->input('status')!="" ? $request->input('status') : "";

          $farmers->save();
          return true;
      } else{
        return false;
      }
    }

    public function addFarmers($request){
      $farmers = new Farmers;

        $farmers->name = $request->input('name')!="" ? $request->input('name') : "";
	$farmers->email = $request->input('email')!="" ? $request->input('email') : "";
	$farmers->mobile = $request->input('mobile')!="" ? $request->input('mobile') : "";
	$farmers->status = $request->input('status')!="" ? $request->input('status') : "";

        $farmers->save();
        return true;
    }
}
