<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Crop_transactions extends Model
{
    protected $table = 'crop_transactions';
    protected $primaryKey = 'cp_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getCrop_transactions($id){
      $data =  Crop_transactions::where('cp_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getCrop_transactionsView($id){
      $crop_transactions = Crop_transactions::select(array('crop_transactions.*' , 'crops.crop' , 'marqua.quality'));
      $crop_transactions->where('crop_transactions.cp_id', $id);
      $crop_transactions->leftJoin('crops', 'crop_transactions.crop', '=','crops.crp_id');$crop_transactions->leftJoin('marqua', 'crop_transactions.marqua', '=','marqua.mq_id');
      return $crop_transactions->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("cp_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $crop_transactions = $this->getCrop_transactions($id);
      if($crop_transactions != null){
        
                    if($field=="status"){
                        $status = $crop_transactions->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $crop_transactions->status=$status;
                        $crop_transactions->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $crop_transactions = $this->getCrop_transactions($id);
      if($crop_transactions !=null){
        $img = public_path().'/uploads/'.$crop_transactions->featured_img;
            if($crop_transactions->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $crop_transactions->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getCrop_transactionsData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $crop_transactions = Crop_transactions::select(array('crop_transactions.*' , 'crops.crop' , 'marqua.quality'));
      
      //join
        $crop_transactions->leftJoin('crops', 'crop_transactions.crop', '=','crops.crp_id');$crop_transactions->leftJoin('marqua', 'crop_transactions.marqua', '=','marqua.mq_id');

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $crop_transactions->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $crop_transactions->orderBy($sortBy, $order);
        } else{
          $crop_transactions->orderBy('crop_transactions.cp_id', 'desc');
        }        

        return $crop_transactions->paginate($per_page);
    }

    public function getCrop_transactionsExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $crop_transactions = Crop_transactions::select(array('crop_transactions.*' , 'crops.crop' , 'marqua.quality'));

      //join
        $crop_transactions->leftJoin('crops', 'crop_transactions.crop', '=','crops.crp_id');$crop_transactions->leftJoin('marqua', 'crop_transactions.marqua', '=','marqua.mq_id');

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $crop_transactions->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $crop_transactions->orderBy($sortBy, $order);
        } else{
          $crop_transactions->orderBy('crop_transactions.cp_id', 'desc');
        }
        return $crop_transactions->get();
    }

    public function updateCrop_transactions($request){
      $id = $request->input('cp_id');
      $crop_transactions = Crop_transactions::getCrop_transactions($id);
      if($crop_transactions !=null){

          $crop_transactions->crop = $request->input('crop')!="" ? $request->input('crop') : "";
	$crop_transactions->marqua = $request->input('marqua')!="" ? $request->input('marqua') : "";
	$crop_transactions->quantity = $request->input('quantity')!="" ? $request->input('quantity') : "";
	$crop_transactions->bangdi = $request->input('bangdi')!="" ? $request->input('bangdi') : "";
	$crop_transactions->weight = $request->input('weight')!="" ? $request->input('weight') : "";
	$crop_transactions->cost = $request->input('cost')!="" ? $request->input('cost') : "";
	$crop_transactions->status = $request->input('status')!="" ? $request->input('status') : "";

          $crop_transactions->save();
          return true;
      } else{
        return false;
      }
    }

    public function addCrop_transactions($request){
      $crop_transactions = new Crop_transactions;

        $crop_transactions->crop = $request->input('crop')!="" ? $request->input('crop') : "";
	$crop_transactions->marqua = $request->input('marqua')!="" ? $request->input('marqua') : "";
	$crop_transactions->quantity = $request->input('quantity')!="" ? $request->input('quantity') : "";
	$crop_transactions->bangdi = $request->input('bangdi')!="" ? $request->input('bangdi') : "";
	$crop_transactions->weight = $request->input('weight')!="" ? $request->input('weight') : "";
	$crop_transactions->cost = $request->input('cost')!="" ? $request->input('cost') : "";
	$crop_transactions->status = $request->input('status')!="" ? $request->input('status') : "";

        $crop_transactions->save();
        return $crop_transactions->cp_id;
    }
}
