<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Buyers extends Model
{
    protected $table = 'buyers';
    protected $primaryKey = 'b_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getBuyers($id){
      $data =  Buyers::where('b_id', $id)->get()->first();
      if($data!=null){
        return $data;
      } else{
        return null;
      }
    }

    public function getBuyersView($id){
      $buyers = Buyers::select(array('buyers.*' , 'trader_company.company_name' , 'traders.name'));
      $buyers->where('buyers.b_id', $id);
      $buyers->leftJoin('trader_company', 'buyers.tc_id', '=','trader_company.tc_id');$buyers->leftJoin('traders', 'buyers.t_id', '=','traders.tl_id');
      return $buyers->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("b_id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $buyers = $this->getBuyers($id);
      if($buyers != null){
        
                    if($field=="status"){
                        $status = $buyers->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $buyers->status=$status;
                        $buyers->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $buyers = $this->getBuyers($id);
      if($buyers !=null){
        $img = public_path().'/uploads/'.$buyers->featured_img;
            if($buyers->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $buyers->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getBuyersData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $buyers = Buyers::select(array('buyers.*' , 'trader_company.company_name' , 'traders.name as trad_name'));
      
      //join
        $buyers->leftJoin('trader_company', 'buyers.tc_id', '=','trader_company.tc_id');$buyers->leftJoin('traders', 'buyers.t_id', '=','traders.tl_id');

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $buyers->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $buyers->orderBy($sortBy, $order);
        } else{
          $buyers->orderBy('buyers.b_id', 'desc');
        }        

        return $buyers->paginate($per_page);
    }

    public function getBuyersExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $buyers = Buyers::select(array('buyers.*' , 'trader_company.company_name' , 'traders.name'));

      //join
        $buyers->leftJoin('trader_company', 'buyers.tc_id', '=','trader_company.tc_id');$buyers->leftJoin('traders', 'buyers.t_id', '=','traders.tl_id');

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $buyers->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $buyers->orderBy($sortBy, $order);
        } else{
          $buyers->orderBy('buyers.b_id', 'desc');
        }
        return $buyers->get();
    }

    public function updateBuyers($request){
      $id = $request->input('b_id');
      $buyers = Buyers::getBuyers($id);
      if($buyers !=null){

          $buyers->tc_id = $request->input('tc_id')!="" ? $request->input('tc_id') : "";
	$buyers->t_id = $request->input('t_id')!="" ? $request->input('t_id') : "";
	$buyers->name = $request->input('name')!="" ? $request->input('name') : "";
	$buyers->email = $request->input('email')!="" ? $request->input('email') : "";
	$buyers->mobile = $request->input('mobile')!="" ? $request->input('mobile') : "";
	$buyers->status = $request->input('status')!="" ? $request->input('status') : "";

          $buyers->save();
          return true;
      } else{
        return false;
      }
    }

    public function addBuyers($request){
      $buyers = new Buyers;

        $buyers->tc_id = $request->input('tc_id')!="" ? $request->input('tc_id') : "";
	$buyers->t_id = $request->input('t_id')!="" ? $request->input('t_id') : "";
	$buyers->name = $request->input('name')!="" ? $request->input('name') : "";
	$buyers->email = $request->input('email')!="" ? $request->input('email') : "";
	$buyers->mobile = $request->input('mobile')!="" ? $request->input('mobile') : "";
	$buyers->status = $request->input('status')!="" ? $request->input('status') : "";

        $buyers->save();
        return $buyers->b_id;
    }
}
