<?php
namespace App;
use DB;
use DateTime;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Mail;
class Master extends Model
{
  public $getDateTime; 
  public function __construct(){
    $this->getDateTime= date('Y-m-d H:i:s');
  }
  public function successResponse($data){
    $return['response']=true;
    $return['code']=200;
    $return['msg']='Success';
    $return['data']=$data;
    return $return;
  }
  public function failureResponse($data){
    $return['response']=false;
    $return['code']=404;
    $return['msg']='No Result Found';
    $return['data']=$data;
    return $return;
  }
  public function html_email($toEmail,$toName,$subject,$msg,$attach=''){
    $this->toEmail=$toEmail;
    $this->toName=$toName;
    $this->subject=$subject;
    $this->attach=$attach;
      $data['msg'] = $msg;
      return Mail::send('send_mail', $data, function($message) {
         $message->to($this->toEmail, $this->toName)->subject($this->subject);
         if($this->attach!=''){
            $message->attach($this->attach);
         }
         $message->from('devs.togglebytes@gmail.com','Smalt');
      });
       
   }
  public function getAll($table)
  {
     return DB::table($table)->get();
  }
  
  public function getSingleDataFirst($table,$where,$sortBy='',$orderBy='')
  {
    $q=DB::table($table)->where($where);
    if($sortBy!='' && $orderBy!=''){
      $q->orderBy($sortBy,$orderBy);
    }
    $ss=$q->get()->first();
    return $ss;
  }
  public function getJointData($table,$tid,$join_table,$jid,$where='',$whereInField='',$whereInValue='',$sortBy='',$order='',$select='',$offset='',$limit='')
  {
    // dd($skip,$take);
    $query=DB::table($table);
    if($select!=''){
      $query->select($select);
    }
    $query->join($join_table,$join_table.'.'.$jid ,'=',$table.'.'.$tid);
    if($where!=''){
      $query->where($where);
    }
     // whereIn condition
        if($whereInField!='' && $whereInValue!='')
        {
          $query->whereIn($whereInField,$whereInValue);
        }
     // sort option
        if($sortBy!='' && $order!='')
        {
          $query->orderBy($sortBy, $order);
        }
     
        //limit
        if($limit!='')
        {
          $query->limit($limit);
        }
        //offset
        if($offset!='')
        {
          $query->offset($offset);
        }
    return $query->get();
  }
  public function getLeftJointData($table,$tid,$join_table,$jid,$where='',$whereInField='',$whereInValue='',$sortBy='',$order='',$select='',$offset='',$limit='')
  {
    // dd($whereInField,$whereInValue,$select);
    $query=DB::table($table);
    if($select!=''){
      $query->select($select);
    }
    $query->leftJoin($join_table,$join_table.'.'.$jid ,'=',$table.'.'.$tid);
    if($where!=''){
      $query->where($where);
    }
     // whereIn condition
        if($whereInField!='' && $whereInValue!='')
        {
          $query->whereIn($whereInField,$whereInValue);
        }
     // sort option
        if($sortBy!='' && $order!='')
        {
          $query->orderBy($sortBy, $order);
        }
         //limit
        if($limit!='')
        {
          $query->limit($limit);
        }
        //offset
        if($offset!='')
        {
          $query->offset($offset);
        }
    return $query->get();
  }
 public function getSingleCol($table,$col_name,$where='')
  {
    // dd($table,$col_name,$where);
    $query=DB::table($table);
    
    if($where!=''){
      $query->where($where);
    }
   
    return $query->pluck($col_name)->first();
  }

  public function checkDataExist($table,$where)
  {
    $data = DB::table($table)->where($where)->exists();
    return $data;
  }
  public function checkExist($table,$where,$request)
  {
    $data = DB::table($table)->where($where)->exists();
    if($data!=true)
    {
      $this->addData($table,$request);
    }else{
      $this->updateData($table,$where,['status'=>1]);
    }
  }

  public function getSingleData($table,$where,$col_name=[])
  {
    $query=DB::table($table)->where($where);
    if($col_name!=[]){
      return $query->get($col_name)->first();
    }
    return $query->get()->first();      
  }

  public function addData($table,$data)
  {
    // dd($table);
    return DB::table($table)->insert($data);
  }
  public function addDataGetID($table,$data)
  {
    return DB::table($table)->insertGetId($data);
  }

  public function updateData($table,$where,$data)
  {
    return DB::table($table)->where($where)->update($data);
  } 

  public function deleteData($table,$where)
  {
    return DB::table($table)->where($where)->delete();
  }
  
  public function getAllData($table,$where,$sortBy='',$order='',$limit='',$offset='',$fields=['*'])
  {
    // dd($fields);
     $master = DB::table($table)->select($fields);
     
     // join

     // where condition
        if($where!='')
        {
          $master->where($where);
        }

     // sort option
        if($sortBy!='' && $order!='')
        {
          $master->orderBy($sortBy, $order);
        } else{
          // $master->orderBy('id', 'desc');
        }
        //limit
        if($limit!=''){
          $master->limit($limit);
        }
        //offset
        if($offset!=''){
          $master->offset($offset);
        }
        if($fields!=[]){return $master->get($fields);}
        return $master->get();
  }
  public function getWhereIn($table,$whereInField,$whereInValue)
  {
    //dd($whereInField,$whereInValue);
    return DB::table($table)->whereIn($whereInField,$whereInValue)->get();
  }
  public function getAllDataWhereIn($table,$where,$whereInField,$whereInValue,$sortBy='',$order='',$limit='',$offset='',$fields=[])
  {
     $master = DB::table($table);
      if($fields!=[]){
          $master->select($fields);
        }

     // $master->select(array('*'));

     // join

     // whereIn condition
        if($whereInField!='' && $whereInValue!='')
        {
          $master->whereIn($whereInField,$whereInValue);
        }
      // where condition
        if($where!='')
        {
          $master->where($where);
        }
     // sort option
        if($sortBy!='' && $order!='')
        {
          $master->orderBy($sortBy, $order);
        } else{
          $master->orderBy('id', 'desc');
        }
        //limit
        if($limit!=''){
          $master->limit($limit);
        }
        //offset
        if($offset!=''){
          $master->offset($offset);
        }
       
        return $master->get();
  }

  


  
  public function getdashboardJointData($table,$tid,$join_table,$jid,$field,$whereInField='',$whereInValue='',$where='')
  {
    $master = DB::table($table);
    $master->select($field);
    $master->join($join_table,$join_table.'.'.$jid ,'=',$table.'.'.$tid);
    
      if($whereInField!='' && $whereInValue!='')
        {
          $master->whereIn($whereInField,$whereInValue);
        }
        // dd($where);
        if($where!='')
        {
          $master->where($where);
        }
       return $master->get();
    // return DB::table($table)->join($join_table,$join_table.'.'.$jid ,'=',$table.'.'.$tid)->get();
     // DB::table($table)->join($join_table,$join_table.'.'.$jid ,'=',$table.'.'.$tid)->where($where)->get($field);
  }
  public function customequery($query){
   
    $master = DB::select($query);
    
    return $master;
   
  }
  public function customequeryNoarray($query){
   //dd($query);
    $master = DB::select($query);
    if(count($master)>0){
    
    return $master[0];
    }
    else {
      return [];
    }
    // dd($master);
  }

  public function getGWData($table,$where,$col)
  {
    return DB::table($table)->where($where)->pluck($col);
  }

  public function singleArray($table,$col)
  {
    return DB::table($table)->pluck($col);
  }
  
}