<?php
namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Transactions;
use DB;
use Illuminate\Support\Facades\Input;

class TransactionsController extends Controller
{
    public function __construct(){
        $this->transactions = new \App\admin\Transactions;
    }

    public $v_fields=array('trader_company.company_name', 'traders.name', 'farmers.name', 'buyers.name', 'transactions.amount', 'transactions.pay_type', 'transactions.bank_name', 'transactions.cheque_no', 'transactions.status');
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function index(Request $request){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';
        $_GET['searchValue']=$_GET['searchValue']??"";
        // order
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
            if(isset($_GET['order']) && $_GET['order']!=''){
                $_GET['order']=$_GET['order']=='asc'?'desc':'asc';
            } else{
                $_GET['order']='desc';
            }
        }

        // create links for field
        $get_q = $_GET;
        foreach ($this->v_fields as $key => $value) {
          $get_q['sortBy'] = $value;
          $get_q['page']=1;
          $query_result = http_build_query($get_q);
          $links[$value.'_link'] =url('/').'/admin/transactions?'.$query_result;
        }
        $links['csvlink'] = url('/').'/admin/transactions/export/csv?'.$_SERVER['QUERY_STRING'];
        $links['pdflink'] = url('/').'/admin/transactions/export/pdf?'.$_SERVER['QUERY_STRING'];

        // pagination per page
        $per_page = isset($_GET['per_page'])?$_GET['per_page']:10;

        // search value
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy=$_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // get by modal
        /*$transactions = new \App\admin\Transactions;*/
        $data = $this->transactions->getTransactionsData($per_page, $searchBy, $searchValue, $sortBy, $order);

        return view('admin/transactions/index', ['data'=>$data->appends(Input::except('page')), 'per_page'=>$per_page, 'links'=>$links]);
    }



    public function getAdd(Request $request){
        /*$transactions = new \App\admin\Transactions;*/
        $data = array('trader_company'=>$this->transactions->getAll('trader_company'),'traders'=>$this->transactions->getAll('traders'),'farmers'=>$this->transactions->getAll('farmers'),'buyers'=>$this->transactions->getAll('buyers'));
        
    	return view('admin/transactions/add', $data);
    }

    public function postEdit(Request $request){

        $this->validate($request, [
            
        ]);

        /*$transactions = new \App\admin\Transactions;*/
        if($this->transactions->updateTransactions($request)){
            
            $request->session()->flash('message', 'Transactions Updated successfully!');
            return redirect()->action('admin\TransactionsController@index');
        } else{
            $request->session()->flash('message', 'Error: Invalid record!');
            return redirect()->action('admin\TransactionsController@index');
        }
    }

    public function postAdd(Request $request){

        $this->validate($request, [
            
        ]);

        /*$transactions = new \App\admin\Transactions;*/

        $insert_id = $this->transactions->addTransactions($request);

        
             
       

        $request->session()->flash('message', 'Transactions added successfully!');
        return redirect()->action('admin\TransactionsController@index');
    }

    public function getEdit($id=''){
        
        /*$transactions = new \App\admin\Transactions;*/
        $data = array('trader_company'=>$this->transactions->getAll('trader_company'),'traders'=>$this->transactions->getAll('traders'),'farmers'=>$this->transactions->getAll('farmers'),'buyers'=>$this->transactions->getAll('buyers'));

        
        
        $data['data'] = $this->transactions->getTransactions($id);
        if(count($data)){
            return view('admin/transactions/edit', $data);
        } else{
            return view('admin/transactions/edit');
        }
    }

    public function view($id){
        /*$transactions = new \App\admin\Transactions;*/
        $data['data'] = $this->transactions->getTransactionsView($id);
        
        
        if(count($data)){
            return view('admin/transactions/view', $data);
        } else{
            return view('admin/transactions/view');
        }
    }

    public function status(Request $request, $field, $id){
        /*$transactions = new \App\admin\Transactions;*/
        $flag = $this->transactions->changeStatus($field, $id);
        // $redirect = $_GET["redirect"];
        if($flag){
            $request->session()->flash('message', 'Status changed successfully!');
            // return redirect($redirect);
            return redirect()->action('admin\TransactionsController@index');
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\TransactionsController@index');
        }
    }

    public function delete(Request $request){
    	$id = $request->input('trans_id');
        /*$transactions = new \App\admin\Transactions;*/
        $flag = $this->transactions->deleteOne($id);
        if($flag){
            $request->session()->flash('message', 'Transactions deleted successfully!');
            if($request->input('redirect')!=''){
                return redirect(urldecode($request->input('redirect')));
            } else{
                return redirect()->action('admin\TransactionsController@index');
            }
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\TransactionsController@index');
        }
    }

    public function deleteAll(Request $request)
    {
        $allIds = $request->input('allIds');
        $flag = false;
        /*$transactions = new \App\admin\Transactions;*/
        for($i=0; $i<count($allIds); $i++)
        {
            if($allIds[$i]!="")
            {
                $id = $allIds[$i];
                $flag = $this->transactions->deleteOne($id);                
            }
        }

        if($flag){
            $request->session()->flash('message', 'Demo deleted successfully!');
        }
    }

    public function getExport($type){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';

        // search query
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy = $_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // sort by
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
        }

        /*$transactions = new \App\admin\Transactions;*/
        $data = $this->transactions->getTransactionsExport($searchBy, $searchValue, $sortBy, $order);

        if($type=='csv'){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=transactions.csv');
            header('Pragma: no-cache');
            $csv='Sr. No,'.implode(',', $this->v_fields)."\n";
            foreach ($data as $key => $value) {
                $line=($key+1).',';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $line.='"'.$value->$field.'"'.',';
                }
                $csv.=ltrim($line,',')."\n";
            }
            echo $csv; exit;
        } elseif($type=='pdf'){
            require_once(app_path().'/libraries/mpdf/mpdf.php');
            $table='
            <html>
            <head><title></title>
            <style>
            table{
                border:1px solid;
            }
            tr:nth-child(even)
            {
                background-color: rgba(158, 158, 158, 0.82);
            }
            </style>
            </head>
            <body>
            <h1 align="center">transactions</h1>
            <table><tr>';
            $table.='<th>Sr. No</th>';
            foreach ($this->v_fields as $value) {
                $table.='<th>'.$value.'</th>';
            }
            $table.='</tr>';
            foreach ($data as $key => $value) {
                $table.='<tr><td>'.($key+1).'</td>';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $table.='<td>'.$value->$field.'</td>';
                }
                $table.='</tr>';
            }
            $table.='</table></body></html>';
            $pdf = new \mPDF();
            $pdf->WriteHTML($table);
            $pdf->Output('transactions.pdf', "D");
            exit;
        } else{
            echo 'Invalid option!';
        }
    }
}
