<?php
namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Sells;
use DB;
use Illuminate\Support\Facades\Input;

class SellsController extends Controller
{
    public function __construct(){
        $this->sells = new \App\admin\Sells;
    }

    public $v_fields=array('trader_company.tc_id', 'traders.name', 'buyers.name', 'sells.transporter_name', 'sells.truck_no', 'sells.status');
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function index(Request $request){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';
        $_GET['searchValue']=$_GET['searchValue']??"";
        // order
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
            if(isset($_GET['order']) && $_GET['order']!=''){
                $_GET['order']=$_GET['order']=='asc'?'desc':'asc';
            } else{
                $_GET['order']='desc';
            }
        }

        // create links for field
        $get_q = $_GET;
        foreach ($this->v_fields as $key => $value) {
          $get_q['sortBy'] = $value;
          $get_q['page']=1;
          $query_result = http_build_query($get_q);
          $links[$value.'_link'] =url('/').'/admin/sells?'.$query_result;
        }
        $links['csvlink'] = url('/').'/admin/sells/export/csv?'.$_SERVER['QUERY_STRING'];
        $links['pdflink'] = url('/').'/admin/sells/export/pdf?'.$_SERVER['QUERY_STRING'];

        // pagination per page
        $per_page = isset($_GET['per_page'])?$_GET['per_page']:10;

        // search value
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy=$_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // get by modal
        /*$sells = new \App\admin\Sells;*/
        $data = $this->sells->getSellsData($per_page, $searchBy, $searchValue, $sortBy, $order);

        return view('admin/sells/index', ['data'=>$data->appends(Input::except('page')), 'per_page'=>$per_page, 'links'=>$links]);
    }



    public function getAdd(Request $request){
        /*$sells = new \App\admin\Sells;*/
        $data = array('trader_company'=>$this->sells->getAll('trader_company'),'traders'=>$this->sells->getAll('traders'),'buyers'=>$this->sells->getAll('buyers'));
        
    	return view('admin/sells/add', $data);
    }

    public function postEdit(Request $request){

        $this->validate($request, [
            
        ]);

        /*$sells = new \App\admin\Sells;*/
        if($this->sells->updateSells($request)){
            
            $request->session()->flash('message', 'Sells Updated successfully!');
            return redirect()->action('admin\SellsController@index');
        } else{
            $request->session()->flash('message', 'Error: Invalid record!');
            return redirect()->action('admin\SellsController@index');
        }
    }

    public function postAdd(Request $request){

        $this->validate($request, [
            
        ]);

        /*$sells = new \App\admin\Sells;*/

        $insert_id = $this->sells->addSells($request);

        
             
       

        $request->session()->flash('message', 'Sells added successfully!');
        return redirect()->action('admin\SellsController@index');
    }

    public function getEdit($id=''){
        
        /*$sells = new \App\admin\Sells;*/
        $data = array('trader_company'=>$this->sells->getAll('trader_company'),'traders'=>$this->sells->getAll('traders'),'buyers'=>$this->sells->getAll('buyers'));

        
        
        $data['data'] = $this->sells->getSells($id);
        if(count($data)){
            return view('admin/sells/edit', $data);
        } else{
            return view('admin/sells/edit');
        }
    }

    public function view($id){
        /*$sells = new \App\admin\Sells;*/
        $data['data'] = $this->sells->getSellsView($id);
        
        
        if(count($data)){
            return view('admin/sells/view', $data);
        } else{
            return view('admin/sells/view');
        }
    }

    public function status(Request $request, $field, $id){
        /*$sells = new \App\admin\Sells;*/
        $flag = $this->sells->changeStatus($field, $id);
        // $redirect = $_GET["redirect"];
        if($flag){
            $request->session()->flash('message', 'Status changed successfully!');
            // return redirect($redirect);
            return redirect()->action('admin\SellsController@index');
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\SellsController@index');
        }
    }

    public function delete(Request $request){
    	$id = $request->input('sell_id');
        /*$sells = new \App\admin\Sells;*/
        $flag = $this->sells->deleteOne($id);
        if($flag){
            $request->session()->flash('message', 'Sells deleted successfully!');
            if($request->input('redirect')!=''){
                return redirect(urldecode($request->input('redirect')));
            } else{
                return redirect()->action('admin\SellsController@index');
            }
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\SellsController@index');
        }
    }

    public function deleteAll(Request $request)
    {
        $allIds = $request->input('allIds');
        $flag = false;
        /*$sells = new \App\admin\Sells;*/
        for($i=0; $i<count($allIds); $i++)
        {
            if($allIds[$i]!="")
            {
                $id = $allIds[$i];
                $flag = $this->sells->deleteOne($id);                
            }
        }

        if($flag){
            $request->session()->flash('message', 'Demo deleted successfully!');
        }
    }

    public function getExport($type){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';

        // search query
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy = $_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // sort by
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
        }

        /*$sells = new \App\admin\Sells;*/
        $data = $this->sells->getSellsExport($searchBy, $searchValue, $sortBy, $order);

        if($type=='csv'){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=sells.csv');
            header('Pragma: no-cache');
            $csv='Sr. No,'.implode(',', $this->v_fields)."\n";
            foreach ($data as $key => $value) {
                $line=($key+1).',';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $line.='"'.$value->$field.'"'.',';
                }
                $csv.=ltrim($line,',')."\n";
            }
            echo $csv; exit;
        } elseif($type=='pdf'){
            require_once(app_path().'/libraries/mpdf/mpdf.php');
            $table='
            <html>
            <head><title></title>
            <style>
            table{
                border:1px solid;
            }
            tr:nth-child(even)
            {
                background-color: rgba(158, 158, 158, 0.82);
            }
            </style>
            </head>
            <body>
            <h1 align="center">sells</h1>
            <table><tr>';
            $table.='<th>Sr. No</th>';
            foreach ($this->v_fields as $value) {
                $table.='<th>'.$value.'</th>';
            }
            $table.='</tr>';
            foreach ($data as $key => $value) {
                $table.='<tr><td>'.($key+1).'</td>';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $table.='<td>'.$value->$field.'</td>';
                }
                $table.='</tr>';
            }
            $table.='</table></body></html>';
            $pdf = new \mPDF();
            $pdf->WriteHTML($table);
            $pdf->Output('sells.pdf', "D");
            exit;
        } else{
            echo 'Invalid option!';
        }
    }
}
