<?php

namespace App\Http\Controllers;

use DB;
use Illuminate\Http\Request;
// use Illuminate\Support\Facades\Hash;
// use Illuminate\Support\Facades\Request;
// use \App\Register;
use Hash;
use Request as Req;
use Auth;

class LoginController extends Controller
{
	public function __construct()
    {
        parent::__construct($this->masterModel);

        $email=Req::header('email');
        $pass=Req::header('password');
        
        if(!Auth::attempt(['email' => $email, 'password' => $pass]))
        {
            echo response()->json(['error'=>'Unauthorised'], 401);
            die();
        }

    }

    public function login(Request $request)
    {
        $validator = \Validator::make($request->all(),[
                        'mobile'=>'required|min:10',
                        'password'=>'required'
                    ]);
        if ($validator->fails()) {
            return $this->masterModel->failureResponse($validator->messages());
        }

    	$trad = $this->masterModel->getSingleData('traders',['mobile'=>$request->input('mobile')]);
        $tradCom = $this->masterModel->getSingleData('trader_company',['mobile'=>$request->input('mobile')]);
    	if($trad)
    	{
    		$check_pass = Hash::check($request->input('password'), $trad->password);
    		if($check_pass)
    		{
                $company = $this->masterModel->getSingleData('trader_company',['tc_id'=>$trad->tc_id,'status'=>1]);
    			$trader = ['id'=>$trad->tl_id,'trader_company'=>$trad->tc_id,'company_name'=>$company->company_name,'name'=>$trad->name,'email'=>$trad->email,'mobile'=>$trad->mobile,'permissions'=>$trad->permissions,'flag'=>2];
    			return $this->masterModel->successResponse($trader); 
    		}else
    		{
                return $this->masterModel->failureResponse('Invalid Password!'); 
    		}
    	}else if($tradCom)
    	{
            $check_pass = Hash::check($request->input('password'), $tradCom->password);
            if($check_pass)
            {
                $trader_company = ['trader_company'=>$tradCom->tc_id,'company_name'=>$tradCom->company_name,'email'=>$tradCom->email,'mobile'=>$tradCom->mobile,'flag'=>1];
                return $this->masterModel->successResponse($trader_company); 
            }else
            {
                return $this->masterModel->failureResponse('Invalid Password!'); 
            }
    	}else
        {
            return $this->masterModel->failureResponse('The user does not exist!'); 
        }
    }

    public function addTrader(Request $request)
    {
        $validator = \Validator::make($request->all(),[
                        'trader_company'=>'required',
                        'name'=>'required',
                        'mobile'=>'required|min:10|unique:traders,mobile',
                        'password'=>'required',
                        'permissions'=>'required',    
                    ]);

        if ($validator->fails()) {
            return $this->masterModel->failureResponse($validator->messages());
        }

    	$exist = $this->masterModel->checkDataExist('traders',['mobile'=>$request->input('mobile')]);
    	if($exist)
    	{
            return $this->masterModel->failureResponse('User already exist!');
    	}else
    	{
    		$user = $this->masterModel->addDataGetID('traders',['tc_id'=>$request->input('trader_company'),'name'=>$request->input('name'),'email'=>$request->input('email'),'mobile'=>$request->input('mobile'),'password'=>Hash::make($request->input('password')),'permissions'=>$request->input('permissions'),'status'=>1,'created'=>date('Y-m-d H:i:s')]);
            return $this->masterModel->successResponse($user);
    	}
    }

    public function viewTrader(Request $request)
    {
        $data = $this->masterModel->getAllData('traders',['tc_id'=>$request->input('trader_company'),'status'=>1]);
        return $this->masterModel->successResponse($data);
    }


}