@extends('frontend.frontMaster')
@section('content')
<div class="wrap pt-3 dashboard">
	<div class="container">
		<div class="row">
			<div class="col-lg-12 col-md-12 col-sm-12 col-12 chart_bg my_account">
				<div class="row">
					<div class="col-lg-6 col-md-6 col-sm-6">
						<h5 class="marg0">My Account</h5>
					</div>
					<div class="col-lg-6 col-md-6 col-sm-6">
						<ul class="nav nav-tabs" role="tablist">
							<li class="nav-item">
								<a class="nav-link active" data-toggle="tab" href="#Transunion">Profile</a>
							</li>
							<li class="nav-item">
								<a class="nav-link" data-toggle="tab" href="#Experian">My Docs</a>
							</li>
							<li class="nav-item">
								<?php if($user->front_photo!=null && $user->back_photo!=null && $user->front_address_proof!=null && $user->back_address_proof!=null){?>
								<a class="nav-link" data-toggle="tab" href="#Equifax">Credits Report</a>
								<?php }else{?>
								<a class="nav-link" data-toggle="tab" href="#">Credits Report</a>	
								<?php }?>	
							</li>
						</ul>
					</div>
				</div>
				<div class="tab-content">
					<div id="Transunion" class="container tab-pane active"><br>
						<div class="row">
							<div class="col-lg-8 col-sm-8">
								<p class="per">Personal
									<a href="javascript:;" class="pull-right editMyAcc">Edit</a>
								</p>
								<div class="row MyAccform">
									<div class="col-lg-6 col-md-6 text-left">
										<div class="form-group">
											<label for="First Name">First Name</label>
											<input type="text" class="form-control border_btm" id="first_name" placeholder="Enter First Name" name="first_name" value="{{$user->first_name ?? ''}}" disabled>
											<span id="errFn" style="color: red;"></span>
										</div>
										<div class="form-group">
											<label for="Email">Email</label>
											<input type="email" class="form-control border_btm" id="email" placeholder="Enter Email Address" name="email" value="{{$user->email ?? ''}}" disabled>
											<span id="errMail" style="color: red;"></span>
										</div>
										<div class="form-group">
											<label for="Address">Address (First Line)</label>
											<input type="text" class="form-control border_btm" id="address" placeholder="Enter Address" name="address" value="{{$user->address ?? ''}}" disabled>
											<span id="errAdd" style="color: red;"></span>
										</div>
										<div class="form-group">
											<label for="state">State</label>
											<select class="form-control select2" name="state" id="state" disabled onchange="getCity(this.value)">
												<option value="">Select</option>
												@foreach($state as $value)
												<option value="{{$value->state_code}}" <?php if(isset($user->state) && $value->state_code==$user->state){echo 'selected';}?>>{{$value->state}}</option>
												@endforeach
											</select>
											<span id="errState" style="color: red;"></span>
										</div>
									</div>
									<div class="col-lg-6 col-md-6 text-left">
										<div class="form-group">
											<label for="Last Name">Last Name</label>
											<input type="text" class="form-control border_btm" id="last_name" placeholder="Enter Last Name" name="last_name" value="{{$user->last_name ?? ''}}" disabled>
											<span id="errLn" style="color: red;"></span>
										</div>
										<div class="form-group">
											<label for="Phone">Phone Number</label>
											<input type="number" class="form-control border_btm" id="phone_number" placeholder="Enter Phone Number" name="phone_number" value="{{$user->mobile ?? ''}}" onkeydown="if(this.value.length==10 && event.keyCode!=8 && event.keyCode!=9) return false;" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" disabled>
											<span id="errPh" style="color: red;"></span>
										</div>
										<div class="form-group">
											<label for="Zip">Zip</label>
											<input type="number" class="form-control border_btm" id="zip_code" placeholder="Enter Zip Code" name="zip _code" value="{{$user->pincode ?? ''}}" onkeydown="if(this.value.length==6 && event.keyCode!=8 && event.keyCode!=9) return false;" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');" disabled>
											<span id="errZip" style="color: red;"></span>
										</div>
										<div class="form-group">
											<label for="city">City</label>
											<select class="form-control select2" name="city" id="city" disabled>
												<option value="">Select</option>
											</select>
											<input type="hidden" name="city_id" value="{{$user->city ?? ''}}">
											<span id="errCity" style="color: red;"></span>
										</div>
									</div>
								</div>
								<p class="per">Security</p>
								<span id="errMsg" style="color: green;"></span>
								<div class="form-group col-md-6 text-left P0">
									<label for="current_password">Current Password</label>
									<input type="password" class="form-control " id="current_password" placeholder="Enter Your Password" name="current_password">
									<span id="errCP" style="color: red;"></span>
								</div>
								<div class="row">
									<div class="form-group col-md-6 text-left ">
										<label for="new_password">New Password</label>
										<input type="password" class="form-control " id="new_password" placeholder="Enter Your Password" name="new_password">
										<span id="errNP" style="color: red;"></span>
									</div>
									<div class="form-group col-md-4 text-center ">
										<label for="Current Password"></label>
										<input type="button" name="next" class="psw-btn" value="Change Password" onclick="updatePassword()">
									</div>
								</div>
								<p class="per">Identity</p>
								<div class="row">
									<div class="form-group col-md-6 text-left ">
										<label for="ADDITIONAL FIRST NAME">ADDITIONAL FIRST NAME</label>
										<input type="text" class="form-control " id="add_first_name" placeholder="First Name" name="add_first_name">
										<span id="errAfn" style="color:red"></span>
										<?php if($user->additional_first_name!=''){$fn = explode(',', $user->additional_first_name);foreach($fn as $val){?>
										<div class="confirm-name mt-2">
								            <i class="fa fa-check"></i>
								            <label class="mr-2 ml-2 text-capitalize">{{$val}}</label>
								            <a href="javascript:;" onclick="deleteAddName('{{$val}}', 'firstname')"> <i class="fa fa-trash"> </i>  </a>
								        </div>
								    <?php }}?>
									</div>
									<div class="form-group col-md-2 text-center ">
										<label for="Current Password"></label>
										<input type="button"  class="psw-btn" value="ADD" onclick="addName('firstname')">
									</div>
								</div>
								<div class="row">
									<div class="form-group col-md-6 text-left ">
										<label for="ADDITIONAL LAST NAME">ADDITIONAL LAST NAME</label>
										<input type="text" class="form-control" id="add_last_name" placeholder="Last Name" name="add_last_name">
										<span id="errAln" style="color:red"></span>
										<?php if($user->additional_last_name!=''){$ln = explode(',', $user->additional_last_name);foreach($ln as $val){?>
										<div class="confirm-name mt-2">
								            <i class="fa fa-check"></i>
								            <label class="mr-2 ml-2 text-capitalize">{{$val}}</label>
								            <a href="javascript:;" onclick="deleteAddName('{{$val}}', 'lastname')"> <i class="fa fa-trash"> </i>  </a>
								        </div>
								  		<?php }}?>
									</div>
									<div class="form-group col-md-2 text-center">
										<label for="Current Password"></label>
										<input type="button"  class="psw-btn" value="ADD" onclick="addName('lastname')">
									</div>
								</div>
							</div>
							<div class="col-md-4 col-sm-4 "></div>
						</div>
					</div>
					<div id="Experian" class="container tab-pane fade"><br>
						<div class="box">
							<div class="js--image-preview"></div>
							<div class="row">
								<div class="col-lg-6 col-md-6 col-sm-6 col-6">		
									<div class="upload-options">
								      	<label><span>PHOTO ID </span>
								      		@if($user->front_photo!='')
								      		<a href="{{url('/')}}/uploads/user_file/{{$user->front_photo}}" target="_blank">
								      			<p class="text-left upload_img">View</p>
								      		</a>
								      		<a href="javascript:;" onclick="deleteUserImage('front_photo')">Delete</a>
								      		@else 	
									      	<a href="javascript:;" onclick="openImageModal('front_photo')">
									      		<p class="text-left upload_img"><i class="fa fa-warning"></i>Front View </p>
									      	</a>
									      	@endif
									    </label>
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-sm-6 col-6">		
									<div class="upload-options">
								      	<label data-toggle="modal"><span>PHOTO ID </span>
								      		@if($user->back_photo!='')
								      		<a href="{{url('/')}}/uploads/user_file/{{$user->back_photo}}" target="_blank">
								      			<p class="text-left upload_img">View</p>
								      		</a>
								      		<a href="javascript:;" onclick="deleteUserImage('back_photo')">Delete</a>
								      		@else 	
									      	<a href="javascript:;" onclick="openImageModal('back_photo')">
									      		<p class="text-left upload_img" ><i class="fa fa-warning"></i>Back View</p>
									      	</a>
									      	@endif
									    </label>
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-sm-6 col-6">		
									<div class="upload-options">
								      	<label data-toggle="modal"><span>PROOF OF ADDRESS </span>
								      		@if($user->front_address_proof!='')
								      		<a href="{{url('/')}}/uploads/user_file/{{$user->front_address_proof}}" target="_blank">
								      			<p class="text-left upload_img">View</p>
								      		</a>
								      		<a href="javascript:;" onclick="deleteUserImage('front_address_proof')">Delete</a>
								      		@else 	
									      	<a href="javascript:;" onclick="openImageModal('front_address_proof')">
									      		<p class="text-left upload_img" ><i class="fa fa-warning"></i>Front View</p>
									      	</a>
									      	@endif
									    </label>
									</div>
								</div>
								<div class="col-lg-6 col-md-6 col-sm-6 col-6">		
									<div class="upload-options">
								      	<label data-toggle="modal"><span>PROOF OF ADDRESS </span>
								      		@if($user->back_address_proof!='')
								      		<a href="{{url('/')}}/uploads/user_file/{{$user->back_address_proof}}" target="_blank">
								      			<p class="text-left upload_img">View</p>
								      		</a>
								      		<a href="javascript:;" onclick="deleteUserImage('back_address_proof')">Delete</a>
								      		@else 	
									      	<a href="javascript:;" onclick="openImageModal('back_address_proof')">
									      		<p class="text-left upload_img" ><i class="fa fa-warning"></i>Back View </p>
									      	</a>
									      	@endif
									    </label>
									</div>
								</div>
							</div>
						</div>
					<h3 class="fs-subtitle">FAQ'S</h3>
					<div class="container demo-btm P0">
						<div id="accordionExample" class="accordion ">
							<div class="card1">
								<div id="headingOne" class="card-header bg-white shadow-sm border-0">
									<h6 class="mb-0 font-weight-bold"><a href="javascript:;" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne" class="d-block position-relative collapsed text-dark text-uppercase collapsible-link py-2">Why should I add my proof of address and photo ID?
									</a></h6>
								</div>
								<div id="collapseOne" aria-labelledby="headingOne" data-parent="#accordionExample" class="collapse">
									<div class="card-body p-5">
										<p class="font-weight-light m-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</p>
									</div>
								</div>
							</div>
							<div class="card1">
								<div id="headingTwo" class="card-header bg-white shadow-sm border-0">
									<h6 class="mb-0 font-weight-bold"><a href="#" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo" class="d-block position-relative collapsed text-dark text-uppercase collapsible-link py-2">What can I use as prooof of address?</a></h6>
								</div>
								<div id="collapseTwo" aria-labelledby="headingTwo" data-parent="#accordionExample" class="collapse">
									<div class="card-body p-5">
										<p class="font-weight-light m-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</p>
									</div>
								</div>
							</div>
							<div class="card1">
								<div id="headingThree" class="card-header bg-white shadow-sm border-0">
									<h6 class="mb-0 font-weight-bold"><a  href="#" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree" class="d-block position-relative collapsed text-dark text-uppercase collapsible-link py-2">What can I use for photo ID?</a></h6>
								</div>
								<div id="collapseThree" aria-labelledby="headingThree" data-parent="#accordionExample" class="collapse">
									<div class="card-body p-5">
										<p class="font-weight-light m-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda +
										shoreditch et.</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div id="Equifax" class="container tab-pane fade"><br>
					@if($user->plan_id!=0)
					@php $master = new \App\Master;$credit = $master->getSingleData('credit_plan',['id'=>$user->plan_id]); @endphp
					<div class="credit_report">
						<div class="col-lg-12 col-md-12 col-sm-12 col-12">
							<p class="per">Your Plan</p>
						</div>
						<div class="row">
							<div class="col-lg-4 col-md-4 ">
								<div class="pricingTable">
									<div class="pricingTable-header">
										<h3 class="title">{{$credit->title}} <?php if($credit->basic=='1'){echo 'Basic';}else if($credit->premium=='1'){echo 'Premium';}?></h3>
									</div>
									<div class="pricing-content">
										<div class="price-value">
											<span class="amount">${{$credit->amount}} /mo</span>
											<span class="cancel">Cancel anytime</span>
										</div>
										{!!$credit->content!!}
										<div class="credit">
											<span>{{$credit->title}}</span>
										</div>
										<p>{{$credit->description}}</p>
									</div>
									<!-- <div class="pricingTable-signup text-center">
										<a href="#">LINK</a>
									</div> -->
								</div>
							</div>
							<div class="col-lg-8 col-md-8 ">
								<div class="smart_credit">
									<a href="javascript:;" class="credit_btn">Manage smart credit account</a>
								</div>
								<p>You can cancel your plan at anytime through your <a href="#">Smart Credit account</a></p>
							</div>
						</div>
					</div>
					@else
					<div class="row">
						<div class="col-lg-12 col-md-12 text-center">
							<h3 class="fs-subtitle">Choose a plan to link 3 bureau credit report.</h3>
							<p><i>This will not create an inquiry or lower your credit score.</i></p>
						</div>
						<div class="col-lg-10 offset-md-1 col-md-10 offset-md-1">
							<div class="row">
								@foreach($plan as $key=>$value)
								<div class="col-md-4 col-sm-6 P5">
									@if($key==0)
									<div class="best_price">
										<p>Best Value!</p>
									</div>
									@endif
									<div class="pricingTable @if($value->basic==0 && $value->premium==0) red @endif">
										<div class="pricingTable-header">
											<h3 class="title">{{$value->title}} <?php if($value->basic=='1'){echo 'Basic';}else if($value->premium=='1'){echo 'Premium';}?></h3>
										</div>
										<div class="pricing-content">
											<div class="price-value">
												<span class="amount">${{$value->amount}} /mo</span>
												<span class="cancel">Cancel anytime</span>
											</div>
											{!!$value->content!!}
											<div class="credit">
												<span>{{$value->title}}</span>
											</div>
											<p>{{$value->description}}</p>
										</div>
										<div class="pricingTable-signup">
											<a href="{{url('/')}}/smartCreditSignUp?member={{encrypt($value->id)}}">LINK</a>
										</div>
									</div>
								</div>
								@endforeach
							</div>
						</div>
					</div>	
					@endif
				</div>
			</div>
		</div>	
	</div>
</div>
</div>

<div class="modal" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog modal_css">
      	<div class="modal-content">
	        <div class="modal-header">
	          	<h4 class="modal-title">Attach File</h4>
	          	<button type="button" class="close" data-dismiss="modal" onclick="$('.modal').hide();">&times;</button>
	        </div>
        	<div class="modal-body">
        		<div class="border_dash">
	          		<div class="drop">Drag your file here  <br> or</div>
					<div class="upload-options">
						<label class="browser_btn">	
					      	<p class="text-left upload_img"> Browse
					        	<input type="file" class="image-upload" accept="image/*" class="" tabindex="" id="imagefile" name="imagefile">
					        </p>
					    </label>
					</div>
					<input type="hidden" name="fileName" id="fileName">
					<input type="hidden" name="imageName" id="imageName">
				</div>
				<div class="list"></div>
				<!-- <div class="status"></div> -->
       		</div>
        	<div class="modal-footer btn_footer">
          		<button type="button" class="btn btn-danger cancel" data-dismiss="modal" onclick="$('.modal').hide();">Cancel</button>
          		<button type="button" class="btn btn-danger save" onclick="saveUserImage()">Save</button>
        	</div>
      	</div>
    </div>
</div>
<script type="text/javascript">
	function openImageModal(name)
	{
		$('.list').html('');
		$('input[name="imagefile"]').val('');
		$('#fileName').val(name);
		$('#myModal').modal('show');
	}

	// drag drop and upload img img js start here
if(window.FileReader) { 
  //var drop; 
  addEventHandler(window, 'load', function() {
    var status = document.getElementsByClassName('status')[0];
    var drop   = document.getElementsByClassName('drop')[0];
    var list   = document.getElementsByClassName('list')[0];

    function cancel(e) {
      if (e.preventDefault) { 
        e.preventDefault(); 
      }
      return false;
    }

    // Tells the browser that we *can* drop on this target
    addEventHandler(drop, 'dragover', cancel);
    addEventHandler(drop, 'dragenter', cancel);
    addEventHandler(drop, 'drop', function (e) {
      e = e || window.event; // get window.event if e argument missing (in IE)   

      if (e.preventDefault) { 
        e.preventDefault(); 
      } // stops the browser from redirecting off to the image.

      var dt = e.dataTransfer;
      var files = dt.files;
      for (var i=0; i<files.length; i++) {
        var file = files[i];
        var reader = new FileReader();

        //attach event handlers here...
        reader.readAsDataURL(file);
        addEventHandler(reader, 'loadend', function(e, file) {
        var bin = this.result; 
        $('.drop').html('<img src="'+e.target.result+'" style="width:150px;height:150px"/>');
        $('.list').html('<i class="fa fa-address-card"></i> <strong>'+file.name+'</strong>');
        $('#imageName').val(file.name);  

        }.bindToEventHandler(file));
      }
      return false;
    });

    Function.prototype.bindToEventHandler = function bindToEventHandler() {
      var handler = this;
      var boundParameters = Array.prototype.slice.call(arguments);
      //create closure
      return function(e) {
        e = e || window.event; // get window.event if e argument missing (in IE)   
        boundParameters.unshift(e);
        handler.apply(this, boundParameters);
      };
    };
  });
} else { 
  document.getElementsByClassName('status')[0].innerHTML = 'Your browser does not support the HTML5 FileReader.';
}

function addEventHandler(obj, evt, handler) {
  if(obj.addEventListener) {
    // W3C method
    obj.addEventListener(evt, handler, false);
  } else if(obj.attachEvent) {
    // IE method.
    obj.attachEvent('on'+evt, handler);
  } else {
    // Old school method.
    obj['on'+evt] = handler;
  }
}

function readURL(input) {
  if (input.files && input.files[0]) {
    var reader = new FileReader();
    
    reader.onload = function(e) {
      $('.drop').html('<img src="'+e.target.result+'" style="width:150px;height:150px"/>');
    }
    $('.list').html('<i class="fa fa-address-card"></i> <strong>'+input.files[0].name+'</strong>');
    reader.readAsDataURL(input.files[0]); // convert to base64 string
  }
}

$("#imagefile").change(function() {
  readURL(this);
});

	function saveUserImage()
	{
		if($('input[name="imagefile"]').val()==''){
			alert('Please select Image');return false;
		}
		var file_name = $('#fileName').val();
		var image_name = $('#imageName').val();
		var fd = new FormData();
        // fd.append('file', files[0]);
        fd.append('file_name',file_name);
        fd.append('file',$('input[name="imagefile"]')[0].files[0]);

        $.ajax({
		 url: "{{url('/')}}/saveUserImage",
		 type: "POST",
		 data: fd,
		 contentType:false,
		 cache: false,
		 processData: false,
		 success: function(data){
		  // $('#drop-area').html(data);
		  if(data=='success'){
		  	// $('.close').trigger('click');
		  	$('.modal').hide();
		  	alert('Image Updated successfully');
		  	window.location.reload(true);
		  	return false;
		  }else{
		  	alert('Something Went Wrong.Please Try Again');
		  	return false;
		  }
		 }});
	}

	function deleteUserImage(col)
	{
		if(confirm('Do you want delete this?'))
		{
			$.ajax({
				type:'post',
				url:'{{url("/")}}/deleteUserImage',
				data:{'_token':'{{csrf_token()}}','col':col},
				success:function(res)
				{
					window.location.reload();
				}
			});
		}
	}


	$(document).ready(function(){	
		$('a[data-toggle="tab"]').on('click', function(e) {
			$('.nav-tabs a[href="' + $(e.target).attr('href') + '"]').tab('show');
		    localStorage.setItem('activeTab', $(e.target).attr('href'));
		});
		var activeTab = localStorage.getItem('activeTab');
		if (activeTab) {
		   $('.nav-tabs a[href="' + activeTab + '"]').tab('show');
		}
	});	
</script>
@endsection