@extends('frontend.frontMaster')
@section('content')
<style type="text/css">
	.credit{position: relative; display: block; align-items: center; margin-top: 10px; margin-bottom: 5px;}
</style>
<div class="wrap PD50">
	<div class="container">
		<div class="row">
			<form id="msform">
				<ul id="progressbar">
					<li>Create Account </li>
					<li>Add Profile </li>
					<li class="active">Credit Report </li>
				</ul>
			</form>
			<div class="col-lg-12 col-md-12 text-center">
				<h3 class="fs-subtitle">Welcome {{Session::get('userLoginInfo')['first_name']}}, your Fix Your Credit account is set up!</h3>
				<p class="marg0">Choose a plan to link 3 bureau credit report.</p>
				<p><i>This will not create an inquiry or lower your credit score.</i></p>
				<p class="marg30"><a class="Skip" href="{{url('/')}}">Skip credit report</a></p>
			</div>
			<div class="col-lg-10 offset-md-1 col-md-10 offset-md-1">
				<div class="row">
					@foreach($plan as $key=>$value)
					<div class="col-md-4 col-sm-6 P5">
						@if($key==0)
						<div class="best_price">
							<p>Best Value!</p>
						</div>
						@endif
						<div class="pricingTable @if($value->basic==0 && $value->premium==0) red @endif">
							<div class="pricingTable-header">
								<h3 class="title">{{$value->title}} <?php if($value->basic=='1'){echo 'Basic';}else if($value->premium=='1'){echo 'Premium';}?></h3>
							</div>
							<div class="pricing-content">
								<div class="price-value">
									<span class="amount">${{$value->amount}} /mo</span>
									<span class="cancel">Cancel anytime</span>
								</div>
								{!!$value->content!!}
								<div class="credit">
									<span>{{$value->title}}</span>
								</div>
								<p>{{$value->description}}</p>
							</div>
							<div class="pricingTable-signup">
								<a href="{{url('/')}}/smartCreditSignUp?member={{encrypt($value->id)}}">LINK</a>
							</div>
						</div>
					</div>
					@endforeach
					<div class="col-lg-12 col-md-12 col-sm-12 col-12 P0 MT50">
						<h3 class="fs-subtitle">FAQ's</h3>
						<div class=" P0">
						   <div id="accordionExample" class="accordion ">
								<div class="card">
									<div id="headingOne" class="card-header bg-white shadow-sm border-0">
										<h6 class="mb-0 font-weight-bold"><a href="javascript:;" data-toggle="collapse" data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne" class="d-block position-relative collapsed text-dark text-uppercase collapsible-link py-2">Why should I add my proof of address and photo ID?
										</a></h6>
									</div>
									<div id="collapseOne" aria-labelledby="headingOne" data-parent="#accordionExample" class="collapse">
										<div class="card-body p-5">
											<p class="font-weight-light m-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</p>
										</div>
									</div>
								</div>
								<div class="card">
									<div id="headingTwo" class="card-header bg-white shadow-sm border-0">
										<h6 class="mb-0 font-weight-bold"><a href="#" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo" class="d-block position-relative collapsed text-dark text-uppercase collapsible-link py-2">What can I use as prooof of address?</a></h6>
									</div>
									<div id="collapseTwo" aria-labelledby="headingTwo" data-parent="#accordionExample" class="collapse">
										<div class="card-body p-5">
											<p class="font-weight-light m-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda shoreditch et.</p>
										</div>
									</div>
								</div>
								<div class="card">
									<div id="headingThree" class="card-header bg-white shadow-sm border-0">
										<h6 class="mb-0 font-weight-bold"><a  href="#" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree" class="d-block position-relative collapsed text-dark text-uppercase collapsible-link py-2">What can I use for photo ID?</a></h6>
									</div>
									<div id="collapseThree" aria-labelledby="headingThree" data-parent="#accordionExample" class="collapse">
										<div class="card-body p-5">
											<p class="font-weight-light m-0">Anim pariatur cliche reprehenderit, enim eiusmod high life accusamus terry richardson ad squid. 3 wolf moon officia aute, non cupidatat skateboard dolor brunch. Food truck quinoa nesciunt laborum eiusmod. Brunch 3 wolf moon tempor, sunt aliqua put a bird on it squid single-origin coffee nulla assumenda +
											shoreditch et.</p>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection