<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class States extends Model
{
    protected $table = 'states';
    protected $primaryKey = 'state_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getState($id){
      $data =  States::where('state_id', $id)->get();
      if(count($data)){
        return $data[0];
      } else{
        return null;
      }
    }

    public function getStateView($id){
      $state = States::select(array('states.*'));
      $state->where('states.state_id', $id);
      
      return $state->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $state = $this->getState($id);
      if($state!=null){
        
                    if($field=="status"){
                        $status = $state->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $state->status=$status;
                        $state->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $state = $this->getState($id);
      if($state!=null){
        $img = public_path().'/uploads/'.$state->featured_img;
            if($state->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $state->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getStateData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $state = States::select(array('states.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $state->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $state->orderBy($sortBy, $order);
        } else{
          $state->orderBy('states.state_id', 'desc');
        }        

        return $state->paginate($per_page);
    }

    public function getStateExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $state = States::select(array('states.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $state->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $state->orderBy($sortBy, $order);
        } else{
          $state->orderBy('states.state_id', 'desc');
        }
        return $state->get();
    }

    public function updateState($request){
      $id = $request->input('id');
      $state = States::getState($id);
      if($state!=null){

          $state->state = $request->input('name')!="" ? $request->input('name') : "";
	$state->status = $request->input('status')!="" ? $request->input('status') : "";

          $state->save();
          return true;
      } else{
        return false;
      }
    }

    public function addState($request){
      $state = new States;

        $state->state = $request->input('name')!="" ? $request->input('name') : "";
	$state->status = $request->input('status')!="" ? $request->input('status') : "";

        $state->save();
        return $state->id;
    }
}
