<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Dispute_master_reasons extends Model
{
    protected $table = 'dispute_master_reasons';
    protected $primaryKey = 'id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getDispute_master_reasons($id){
      $data =  Dispute_master_reasons::where('id', $id)->get();
      if(count($data)){
        return $data[0];
      } else{
        return array();
      }
    }

    public function getDispute_master_reasonsView($id){
      $dispute_master_reasons = Dispute_master_reasons::select(array('dispute_master_reasons.*'));
      $dispute_master_reasons->where('dispute_master_reasons.id', $id);
      
      return $dispute_master_reasons->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $dispute_master_reasons = $this->getDispute_master_reasons($id);
      if(count($dispute_master_reasons)){
        
                    if($field=="status"){
                        $status = $dispute_master_reasons->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $dispute_master_reasons->status=$status;
                        $dispute_master_reasons->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $dispute_master_reasons = $this->getDispute_master_reasons($id);
      if(count($dispute_master_reasons)){
        $img = public_path().'/uploads/'.$dispute_master_reasons->featured_img;
            if($dispute_master_reasons->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $dispute_master_reasons->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getDispute_master_reasonsData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $dispute_master_reasons = Dispute_master_reasons::select(array('dispute_master_reasons.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $dispute_master_reasons->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $dispute_master_reasons->orderBy($sortBy, $order);
        } else{
          $dispute_master_reasons->orderBy('dispute_master_reasons.id', 'desc');
        }        

        return $dispute_master_reasons->paginate($per_page);
    }

    public function getDispute_master_reasonsExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $dispute_master_reasons = Dispute_master_reasons::select(array('dispute_master_reasons.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $dispute_master_reasons->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $dispute_master_reasons->orderBy($sortBy, $order);
        } else{
          $dispute_master_reasons->orderBy('dispute_master_reasons.id', 'desc');
        }
        return $dispute_master_reasons->get();
    }

    public function updateDispute_master_reasons($request){
      $id = $request->input('id');
      $dispute_master_reasons = Dispute_master_reasons::getDispute_master_reasons($id);
      if(count($dispute_master_reasons)){

          $dispute_master_reasons->subject = $request->input('subject')!="" ? $request->input('subject') : "";
	$dispute_master_reasons->reason = $request->input('reason')!="" ? $request->input('reason') : "";
	$dispute_master_reasons->status = $request->input('status')!="" ? $request->input('status') : "";

          $dispute_master_reasons->save();
          return true;
      } else{
        return false;
      }
    }

    public function addDispute_master_reasons($request){
      $dispute_master_reasons = new Dispute_master_reasons;

        $dispute_master_reasons->subject = $request->input('subject')!="" ? $request->input('subject') : "";
	$dispute_master_reasons->reason = $request->input('reason')!="" ? $request->input('reason') : "";
	$dispute_master_reasons->status = $request->input('status')!="" ? $request->input('status') : "";

        $dispute_master_reasons->save();
        return $dispute_master_reasons->id;
    }
}
