<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class Credit_plan extends Model
{
    protected $table = 'credit_plan';
    protected $primaryKey = 'id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getCredit_plan($id){
      $data =  Credit_plan::where('id', $id)->get();
      if(count($data)){
        return $data[0];
      } else{
        return null;
      }
    }

    public function getCredit_planView($id){
      $credit_plan = Credit_plan::select(array('credit_plan.*'));
      $credit_plan->where('credit_plan.id', $id);
      
      return $credit_plan->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $credit_plan = $this->getCredit_plan($id);
      if($credit_plan!=null){
        
                    if($field=="status"){
                        $status = $credit_plan->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $credit_plan->status=$status;
                        $credit_plan->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $credit_plan = $this->getCredit_plan($id);
      if($credit_plan!=null){
        $img = public_path().'/uploads/'.$credit_plan->featured_img;
            if($credit_plan->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $credit_plan->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getCredit_planData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $credit_plan = Credit_plan::select(array('credit_plan.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $credit_plan->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $credit_plan->orderBy($sortBy, $order);
        } else{
          $credit_plan->orderBy('credit_plan.id', 'desc');
        }        

        return $credit_plan->paginate($per_page);
    }

    public function getCredit_planExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $credit_plan = Credit_plan::select(array('credit_plan.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $credit_plan->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $credit_plan->orderBy($sortBy, $order);
        } else{
          $credit_plan->orderBy('credit_plan.id', 'desc');
        }
        return $credit_plan->get();
    }

    public function updateCredit_plan($request){
      $id = $request->input('id');
      $credit_plan = Credit_plan::getCredit_plan($id);
      if($credit_plan!=null){

          $credit_plan->title = $request->input('title')!="" ? $request->input('title') : "";
        	$credit_plan->amount = $request->input('amount')!="" ? $request->input('amount') : "";
        	$credit_plan->content = $request->input('content')!="" ? $request->input('content') : "";
        	$credit_plan->description = $request->input('description')!="" ? $request->input('description') : "";
          $credit_plan->basic = $request->input('basic')!="" ? $request->input('basic') : "";
        	$credit_plan->premium = $request->input('premium')!="" ? $request->input('premium') : "";
          $credit_plan->status = $request->input('status')!="" ? $request->input('status') : "";

          $credit_plan->save();
          return true;
      } else{
        return false;
      }
    }

    public function addCredit_plan($request){
      $credit_plan = new Credit_plan;

        $credit_plan->title = $request->input('title')!="" ? $request->input('title') : "";
      	$credit_plan->amount = $request->input('amount')!="" ? $request->input('amount') : "";
      	$credit_plan->content = $request->input('content')!="" ? $request->input('content') : "";
      	$credit_plan->description = $request->input('description')!="" ? $request->input('description') : "";
        $credit_plan->basic = $request->input('basic')!="" ? $request->input('basic') : "";
        $credit_plan->premium = $request->input('premium')!="" ? $request->input('premium') : "";
      	$credit_plan->status = $request->input('status')!="" ? $request->input('status') : "";

        $credit_plan->save();
        return $credit_plan->id;
    }
}
