<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class CreditOffer extends Model
{
    protected $table = 'credit_offer';
    protected $primaryKey = 'id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getCredit_offer($id){
      $data =  CreditOffer::where('id', $id)->get();
      if(count($data)){
        return $data[0];
      } else{
        return null;
      }
    }

    public function getCredit_offerView($id){
      $credit_offer = CreditOffer::select(array('credit_offer.*'));
      $credit_offer->where('credit_offer.id', $id);
      
      return $credit_offer->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $credit_offer = $this->getCredit_offer($id);
      if($credit_offer!=null){
        
                    if($field=="status"){
                        $status = $credit_offer->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $credit_offer->status=$status;
                        $credit_offer->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $credit_offer = $this->getCredit_offer($id);
      if($credit_offer!=null){
        $img = public_path().'/uploads/'.$credit_offer->featured_img;
            if($credit_offer->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $credit_offer->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getCredit_offerData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $credit_offer = CreditOffer::select(array('credit_offer.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $credit_offer->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $credit_offer->orderBy($sortBy, $order);
        } else{
          $credit_offer->orderBy('credit_offer.id', 'desc');
        }        

        return $credit_offer->paginate($per_page);
    }

    public function getCredit_offerExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $credit_offer = CreditOffer::select(array('credit_offer.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $credit_offer->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $credit_offer->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $credit_offer->orderBy($sortBy, $order);
        } else{
          $credit_offer->orderBy('credit_offer.id', 'desc');
        }
        return $credit_offer->get();
    }

    public function updateCredit_offer($request){
      $id = $request->input('id');
      $credit_offer = CreditOffer::getCredit_offer($id);
      if($credit_offer!=null){

          $credit_offer->title = $request->input('title')!="" ? $request->input('title') : "";
          $credit_offer->card_image = $request->input('card_image')=="" ? $request->input('old_card_image') : $request->input('card_image') ;
  
                    // image upload code
                    $card_image_name='';
                    $card_image_file = $request->file('card_image');
                    if(!is_null($card_image_file) && in_array($card_image_file->getClientOriginalExtension(), $this->allow_image)){
                        $card_image_name = time().'_'.$card_image_file->getClientOriginalName();
                        $card_image_file->move('uploads',$card_image_name);
                        $credit_offer->card_image = $card_image_name;
                    }
                    
          $credit_offer->odds = $request->input('odds')!="" ? $request->input('odds') : "";
          $credit_offer->annual_fee = $request->input('annual_fee')!="" ? $request->input('annual_fee') : "";
          $credit_offer->security_deposit = $request->input('security_deposit')!="" ? $request->input('security_deposit') : "";
          $credit_offer->url = $request->input('url')!="" ? $request->input('url') : "";
          $credit_offer->status = $request->input('status')!="" ? $request->input('status') : "";

          $credit_offer->save();
          return true;
      } else{
        return false;
      }
    }

    public function addCredit_offer($request){
      $credit_offer = new CreditOffer;

        $credit_offer->title = $request->input('title')!="" ? $request->input('title') : "";
        $credit_offer->card_image = $request->input('card_image')=="" ? $request->input('old_card_image') : $request->input('card_image') ;
  
                    // image upload code
                    $card_image_name='';
                    $card_image_file = $request->file('card_image');
                    if(!is_null($card_image_file) && in_array($card_image_file->getClientOriginalExtension(), $this->allow_image)){
                        $card_image_name = time().'_'.$card_image_file->getClientOriginalName();
                        $card_image_file->move('uploads',$card_image_name);
                        $credit_offer->card_image = $card_image_name;
                    }
                    
        $credit_offer->odds = $request->input('odds')!="" ? $request->input('odds') : "";
        $credit_offer->annual_fee = $request->input('annual_fee')!="" ? $request->input('annual_fee') : "";
        $credit_offer->security_deposit = $request->input('security_deposit')!="" ? $request->input('security_deposit') : "";
        $credit_offer->url = $request->input('url')!="" ? $request->input('url') : "";
        $credit_offer->status = $request->input('status')!="" ? $request->input('status') : "";
        $credit_offer->created = date('Y-m-d H:i:s');

        $credit_offer->save();
        return $credit_offer->id;
    }
}
