<?php

namespace App\admin;
use DB;
use Illuminate\Database\Eloquent\Model;

class City extends Model
{
    protected $table = 'cities';
    protected $primaryKey = 'city_id';
    public $timestamps = false;
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function getAll($table){
      return DB::table($table)->get();
    }


    public function getCity($id){
      $data =  City::where('city_id', $id)->get();
      if(count($data)){
        return $data[0];
      } else{
        return null;
      }
    }

    public function getCityView($id){
      $city = City::select(array('cities.*'));
      $city->where('cities.city_id', $id);
      
      return $city->get()[0];

    }

    public function multiSelectInsert($r_table, $field1, $value1, $field2, $value2=array())
    {
      DB::table("$r_table")->where("$field1", $value1)->delete();
      if ($r_table!="" && $field1!="" && $value1!="" && $field2!="" && count($value2)>0) {
        for ($i=0; $i < count($value2); $i++) {
          $data[] = array(
            $field1 => $value1,
            $field2 => $value2[$i],
          );
        }
        DB::table("$r_table")->insert($data);
      }
    }

    public function getSelectedIds($table, $id, $where_field, $select_field)
    {
       $arr = array();
       $data = DB::table("$table")->select("$select_field")->where(array($where_field=>$id))->get();
       foreach ($data as $key => $value) {
            $arr[] = $value->$select_field;
        }
        return $arr;
    }


    function getSelectedData($table, $field, $idArr) {
        $arr = array();
        $data = DB::table("$table")->select("*")->whereIn("id",$idArr)->get();
        foreach ($data as $key => $value) {
            $arr[] = $value->$field;
        }
        return $arr;
    }


    public function changeStatus($field, $id){
      $city = $this->getCity($id);
      if($city!=null){
        
                    if($field=="status"){
                        $status = $city->status;
                        if($status==1){
                            $status=0;
                        } else{
                            $status=1;
                        }
                        $city->status=$status;
                        $city->save();
                    }
                    
            return true;
      } else{
        return false;
      }
    }

    public function deleteOne($id){
      $city = $this->getCity($id);
      if($city!=null){
        $img = public_path().'/uploads/'.$city->featured_img;
            if($city->featured_img!='' && file_exists($img)){
                unlink($img);
            }
            $city->delete();
        return true;
      } else{
        return false;
      }
    }
    
    public function getCityData($per_page, $searchBy, $searchValue, $sortBy, $order){
      $city = City::select(array('cities.*'));
      
      //join
        

        // where condition
        if($searchBy!='' && $searchValue!=''){
          $city->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $city->orderBy($sortBy, $order);
        } else{
          $city->orderBy('cities.city_id', 'desc');
        }        

        return $city->paginate($per_page);
    }

    public function getCityExport($searchBy='', $searchValue='', $sortBy='', $order=''){
      $city = City::select(array('cities.*'));

      //join
        

        // where condition
        if($searchBy!='' && $searchValue!='') {
          $city->where($searchBy, 'like', '%'.$searchValue.'%');
        }

        if (isset($rel_arr) && !empty($rel_arr)) {
            $products->where($rel_arr['rel_field'], '=', $rel_arr['rel_id']);
        }

        // sort option
        if($sortBy!='' && $order!=''){
          $city->orderBy($sortBy, $order);
        } else{
          $city->orderBy('cities.city_id', 'desc');
        }
        return $city->get();
    }

    public function updateCity($request){
      $id = $request->input('id');
      $city = City::getCity($id);
      if($city!=null){

          $city->city = $request->input('name')!="" ? $request->input('name') : "";
	$city->status = $request->input('status')!="" ? $request->input('status') : "";

          $city->save();
          return true;
      } else{
        return false;
      }
    }

    public function addCity($request){
      $city = new City;

        $city->city = $request->input('name')!="" ? $request->input('name') : "";
	$city->status = $request->input('status')!="" ? $request->input('status') : "";

        $city->save();
        return $city->id;
    }
}
