<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Dispute_master_reasons;
use DB;
use Illuminate\Support\Facades\Input;

class Dispute_master_reasonsController extends Controller
{
    public $v_fields=array('dispute_master_reasons.subject', 'dispute_master_reasons.reason', 'dispute_master_reasons.status');
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function index(Request $request){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';
        $_GET['searchValue']=$_GET['searchValue']??"";
        // order
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
            if(isset($_GET['order']) && $_GET['order']!=''){
                $_GET['order']=$_GET['order']=='asc'?'desc':'asc';
            } else{
                $_GET['order']='desc';
            }
        }

        // create links for field
        $get_q = $_GET;
        foreach ($this->v_fields as $key => $value) {
          $get_q['sortBy'] = $value;
          $get_q['page']=1;
          $query_result = http_build_query($get_q);
          $links[$value.'_link'] =url('/').'/admin/dispute_master_reasons?'.$query_result;
        }
        $links['csvlink'] = url('/').'/admin/dispute_master_reasons/export/csv?'.$_SERVER['QUERY_STRING'];
        $links['pdflink'] = url('/').'/admin/dispute_master_reasons/export/pdf?'.$_SERVER['QUERY_STRING'];

        // pagination per page
        $per_page = isset($_GET['per_page'])?$_GET['per_page']:10;

        // search value
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy=$_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // get by modal
        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        $data = $dispute_master_reasons->getDispute_master_reasonsData($per_page, $searchBy, $searchValue, $sortBy, $order);

        return view('admin/dispute_master_reasons/index', ['data'=>$data->appends(Input::except('page')), 'per_page'=>$per_page, 'links'=>$links]);
    }



    public function getAdd(Request $request){
        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        $data = array();
        
    	return view('admin/dispute_master_reasons/add', $data);
    }

    public function postEdit(Request $request){

        $this->validate($request, [
            
        ]);

        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        if($dispute_master_reasons->updateDispute_master_reasons($request)){
            
            $request->session()->flash('message', 'Dispute_master_reasons Updated successfully!');
            return redirect()->action('admin\Dispute_master_reasonsController@index');
        } else{
            $request->session()->flash('message', 'Error: Invalid record!');
            return redirect()->action('admin\Dispute_master_reasonsController@index');
        }
    }

    public function postAdd(Request $request){

        $this->validate($request, [
            
        ]);

        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;

        $insert_id = $dispute_master_reasons->addDispute_master_reasons($request);

        
             
       

        $request->session()->flash('message', 'Dispute_master_reasons added successfully!');
        return redirect()->action('admin\Dispute_master_reasonsController@index');
    }

    public function getEdit($id=''){
        
        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        $data = array();

        
        
        $data['data'] = $dispute_master_reasons->getDispute_master_reasons($id);
        if(count($data)){
            return view('admin/dispute_master_reasons/edit', $data);
        } else{
            return view('admin/dispute_master_reasons/edit');
        }
    }

    public function view($id){
        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        $data['data'] = $dispute_master_reasons->getDispute_master_reasonsView($id);
        
        
        if(count($data)){
            return view('admin/dispute_master_reasons/view', $data);
        } else{
            return view('admin/dispute_master_reasons/view');
        }
    }

    public function status(Request $request, $field, $id){
        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        $flag = $dispute_master_reasons->changeStatus($field, $id);
        // $redirect = $_GET["redirect"];
        if($flag){
            $request->session()->flash('message', 'Status changed successfully!');
            // return redirect($redirect);
            return redirect()->action('admin\Dispute_master_reasonsController@index');
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\Dispute_master_reasonsController@index');
        }
    }

    public function delete(Request $request){
    	$id = $request->input('id');
        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        $flag = $dispute_master_reasons->deleteOne($id);
        if($flag){
            $request->session()->flash('message', 'Dispute_master_reasons deleted successfully!');
            if($request->input('redirect')!=''){
                return redirect(urldecode($request->input('redirect')));
            } else{
                return redirect()->action('admin\Dispute_master_reasonsController@index');
            }
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\Dispute_master_reasonsController@index');
        }
    }

    public function deleteAll(Request $request)
    {
        $allIds = $request->input('allIds');
        $flag = false;
        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        for($i=0; $i<count($allIds); $i++)
        {
            if($allIds[$i]!="")
            {
                $id = $allIds[$i];
                $flag = $dispute_master_reasons->deleteOne($id);                
            }
        }

        if($flag){
            $request->session()->flash('message', 'Demo deleted successfully!');
        }
    }

    public function getExport($type){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';

        // search query
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy = $_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // sort by
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
        }

        $dispute_master_reasons = new \App\admin\Dispute_master_reasons;
        $data = $dispute_master_reasons->getDispute_master_reasonsExport($searchBy, $searchValue, $sortBy, $order);

        if($type=='csv'){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=dispute_master_reasons.csv');
            header('Pragma: no-cache');
            $csv='Sr. No,'.implode(',', $this->v_fields)."\n";
            foreach ($data as $key => $value) {
                $line=($key+1).',';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $line.='"'.$value->$field.'"'.',';
                }
                $csv.=ltrim($line,',')."\n";
            }
            echo $csv; exit;
        } elseif($type=='pdf'){
            require_once(app_path().'/libraries/mpdf60/mpdf.php');
            $table='
            <html>
            <head><title></title>
            <style>
            table{
                border:1px solid;
            }
            tr:nth-child(even)
            {
                background-color: rgba(158, 158, 158, 0.82);
            }
            </style>
            </head>
            <body>
            <h1 align="center">dispute_master_reasons</h1>
            <table><tr>';
            $table.='<th>Sr. No</th>';
            foreach ($this->v_fields as $value) {
                $table.='<th>'.$value.'</th>';
            }
            $table.='</tr>';
            foreach ($data as $key => $value) {
                $table.='<tr><td>'.($key+1).'</td>';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $table.='<td>'.$value->$field.'</td>';
                }
                $table.='</tr>';
            }
            $table.='</table></body></html>';
            $pdf = new \mPDF();
            $pdf->WriteHTML($table);
            $pdf->Output('dispute_master_reasons.pdf', "D");
            exit;
        } else{
            echo 'Invalid option!';
        }
    }
}
