<?php

namespace App\Http\Controllers\admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Credit_plan;
use DB;
use Illuminate\Support\Facades\Input;

class Credit_planController extends Controller
{
    public $v_fields=array('credit_plan.title', 'credit_plan.amount', 'credit_plan.content', 'credit_plan.description', 'credit_plan.status');
    public $allow_image = array('png', 'jpg', 'jpeg', 'gif');

    public function index(Request $request){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';
        $_GET['searchValue']=$_GET['searchValue']??"";
        // order
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
            if(isset($_GET['order']) && $_GET['order']!=''){
                $_GET['order']=$_GET['order']=='asc'?'desc':'asc';
            } else{
                $_GET['order']='desc';
            }
        }

        // create links for field
        $get_q = $_GET;
        foreach ($this->v_fields as $key => $value) {
          $get_q['sortBy'] = $value;
          $get_q['page']=1;
          $query_result = http_build_query($get_q);
          $links[$value.'_link'] =url('/').'/admin/credit_plan?'.$query_result;
        }
        $links['csvlink'] = url('/').'/admin/credit_plan/export/csv?'.$_SERVER['QUERY_STRING'];
        $links['pdflink'] = url('/').'/admin/credit_plan/export/pdf?'.$_SERVER['QUERY_STRING'];

        // pagination per page
        $per_page = isset($_GET['per_page'])?$_GET['per_page']:10;

        // search value
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy=$_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // get by modal
        $credit_plan = new \App\admin\Credit_plan;
        $data = $credit_plan->getCredit_planData($per_page, $searchBy, $searchValue, $sortBy, $order);

        return view('admin/credit_plan/index', ['data'=>$data->appends(Input::except('page')), 'per_page'=>$per_page, 'links'=>$links]);
    }



    public function getAdd(Request $request){
        $credit_plan = new \App\admin\Credit_plan;
        $data = array();
        
    	return view('admin/credit_plan/add', $data);
    }

    public function postEdit(Request $request){

        $this->validate($request, [
            
        ]);

        $credit_plan = new \App\admin\Credit_plan;
        if($credit_plan->updateCredit_plan($request)){
            
            $request->session()->flash('message', 'Credit_plan Updated successfully!');
            return redirect()->action('admin\Credit_planController@index');
        } else{
            $request->session()->flash('message', 'Error: Invalid record!');
            return redirect()->action('admin\Credit_planController@index');
        }
    }

    public function postAdd(Request $request){

        $this->validate($request, [
            
        ]);

        $credit_plan = new \App\admin\Credit_plan;

        $insert_id = $credit_plan->addCredit_plan($request);

        
             
       

        $request->session()->flash('message', 'Credit_plan added successfully!');
        return redirect()->action('admin\Credit_planController@index');
    }

    public function getEdit($id=''){
        
        $credit_plan = new \App\admin\Credit_plan;
        $data = array();

        
        
        $data['data'] = $credit_plan->getCredit_plan($id);
        if(count($data)){
            return view('admin/credit_plan/edit', $data);
        } else{
            return view('admin/credit_plan/edit');
        }
    }

    public function view($id){
        $credit_plan = new \App\admin\Credit_plan;
        $data['data'] = $credit_plan->getCredit_planView($id);
        
        
        if(count($data)){
            return view('admin/credit_plan/view', $data);
        } else{
            return view('admin/credit_plan/view');
        }
    }

    public function status(Request $request, $field, $id){
        $credit_plan = new \App\admin\Credit_plan;
        $flag = $credit_plan->changeStatus($field, $id);
        // $redirect = $_GET["redirect"];
        if($flag){
            $request->session()->flash('message', 'Status changed successfully!');
            // return redirect($redirect);
            return redirect()->action('admin\Credit_planController@index');
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\Credit_planController@index');
        }
    }

    public function delete(Request $request){
    	$id = $request->input('id');
        $credit_plan = new \App\admin\Credit_plan;
        $flag = $credit_plan->deleteOne($id);
        if($flag){
            $request->session()->flash('message', 'Credit_plan deleted successfully!');
            if($request->input('redirect')!=''){
                return redirect(urldecode($request->input('redirect')));
            } else{
                return redirect()->action('admin\Credit_planController@index');
            }
        } else{
            $request->session()->flash('message', 'Invalid id!');
            return redirect()->action('admin\Credit_planController@index');
        }
    }

    public function deleteAll(Request $request)
    {
        $allIds = $request->input('allIds');
        $flag = false;
        $credit_plan = new \App\admin\Credit_plan;
        for($i=0; $i<count($allIds); $i++)
        {
            if($allIds[$i]!="")
            {
                $id = $allIds[$i];
                $flag = $credit_plan->deleteOne($id);                
            }
        }

        if($flag){
            $request->session()->flash('message', 'Demo deleted successfully!');
        }
    }

    public function getExport($type){
        $sortBy='';
        $order = '';
        $searchBy='';
        $searchValue='';

        // search query
        if(isset($_GET['searchBy']) && in_array($_GET['searchBy'], $this->v_fields) && $_GET['searchValue']!=''){
            $searchBy = $_GET['searchBy'];
            $searchValue = $_GET['searchValue'];
        }

        // sort by
        if(isset($_GET['sortBy']) && in_array($_GET['sortBy'], $this->v_fields)){
            $sortBy=$_GET['sortBy'];
            $order = isset($_GET['order']) && $_GET['order']=='asc'?'asc':'desc';
        }

        $credit_plan = new \App\admin\Credit_plan;
        $data = $credit_plan->getCredit_planExport($searchBy, $searchValue, $sortBy, $order);

        if($type=='csv'){
            header('Content-Type: application/csv');
            header('Content-Disposition: attachment; filename=credit_plan.csv');
            header('Pragma: no-cache');
            $csv='Sr. No,'.implode(',', $this->v_fields)."\n";
            foreach ($data as $key => $value) {
                $line=($key+1).',';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $line.='"'.$value->$field.'"'.',';
                }
                $csv.=ltrim($line,',')."\n";
            }
            echo $csv; exit;
        } elseif($type=='pdf'){
            require_once(app_path().'/libraries/mpdf60/mpdf.php');
            $table='
            <html>
            <head><title></title>
            <style>
            table{
                border:1px solid;
            }
            tr:nth-child(even)
            {
                background-color: rgba(158, 158, 158, 0.82);
            }
            </style>
            </head>
            <body>
            <h1 align="center">credit_plan</h1>
            <table><tr>';
            $table.='<th>Sr. No</th>';
            foreach ($this->v_fields as $value) {
                $table.='<th>'.$value.'</th>';
            }
            $table.='</tr>';
            foreach ($data as $key => $value) {
                $table.='<tr><td>'.($key+1).'</td>';
                foreach ($this->v_fields as $field) {
                    $field = explode('.', $field);
                    $field = end($field);
                    $table.='<td>'.$value->$field.'</td>';
                }
                $table.='</tr>';
            }
            $table.='</table></body></html>';
            $pdf = new \mPDF();
            $pdf->WriteHTML($table);
            $pdf->Output('credit_plan.pdf', "D");
            exit;
        } else{
            echo 'Invalid option!';
        }
    }
}
