<?php
namespace App\Http\Controllers;

use App\Http\Requests;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Session;
use DB;

class ExtApiController extends Controller
{
	 public function __construct()
    {
        parent::__construct($this->masterModel);
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */

    public function credit(){
      // dd(sprintf("%'03d", 1));
      $user_id=1;
      Session::put('reportUserId',$user_id);
        $token=$this->mfcnLogin();
        $refreshThreeBReport=$this->refreshThreeBReport($token);
        var_dump($refreshThreeBReport,json_encode($refreshThreeBReport));
        if($refreshThreeBReport->status=='SUCCESS' && $refreshThreeBReport->message=='Report Updated Successfully'){
          $threeBdata=$this->getThreeBReport($token);
          $bundle=$threeBdata->BundleComponents->BundleComponent ?? '';
          // $totRiskScore=$bundle[3]->CreditScoreType->CreditScoreFactor ??;
          $CreditScoreFactorArr=[$bundle[3] ?? [],$bundle[4] ?? [],$bundle[5] ?? []];
          $this->CreditScoreType($CreditScoreFactorArr);
          // $this->tradeLine($CreditScoreFactorArr);
          // $totRiskScore=$bundle[3]->CreditScoreType->riskScore;
          $tradeLine=$bundle[6]->TrueLinkCreditReportType->TradeLinePartition;
          dd($tradeLine);
          $this->addTradelineSummary($bundle[6]->TrueLinkCreditReportType->Summary->TradelineSummary ?? []);
          $this->addInquirySummary($bundle[6]->TrueLinkCreditReportType->Summary->InquirySummary ?? []);
          $this->addPublicRecordSummary($bundle[6]->TrueLinkCreditReportType->Summary->PublicRecordSummary ?? []);
          foreach ($tradeLine as $key => $value) {
            // dd($tradeLine,$value->Tradeline);
            foreach ($value->Tradeline as $key => $val) {
              // var_dump($val);
              // $this->tradeLine($val);
              $t[]=$val;
            }
          }
        }else{
          $this->masterModel->addData('myfsn_refresh_report',['user_id'=>$user_id,'status'=>json_encode($refreshThreeBReport)]);
        }
        dd($t,$threeBdata);
    }
    public function CreditScoreType($arr){
      foreach ($arr as $key => $value) {
        $credit['user_id']=Session::get('reportUserId');
        $credit['scoreName']=$value->CreditScoreType->scoreName ?? '';
        $credit['riskScore']=$value->CreditScoreType->riskScore ?? 0;
        $credit['populationRank']=$value->CreditScoreType->populationRank ?? 0;
        $credit['inquiriesAffectedScore']=$value->CreditScoreType->inquiriesAffectedScore ?? '';
        $credit['source_type']=$this->getSourceType($value->CreditScoreType->Source->Bureau->abbreviation);
        $credit['created']=date('Y-m-d H:i:s');
      // dd($arr,$value,$credit);
        $crdId=$this->masterModel->addDataGetID('creditscore',$credit);
        $this->CreditScoreFactor($value->CreditScoreType->CreditScoreFactor,$crdId);
      }
    }
    public function CreditScoreFactor($arr,$crdId){
      foreach ($arr as $key => $value) {
        // dd($value);
        $cf['user_id']=Session::get('reportUserId');
        $cf['creditscore_id']=$crdId;
        $cf['bureauCode']=$value->bureauCode ?? '';
        $cf['FactorType']=$value->FactorType ?? '';
        $cf['symbol']=$value->Factor->symbol ?? '';
        $cf['rank']=$value->Factor->rank ?? '';
        $cf['created']=date('Y-m-d H:i:s');
        $this->masterModel->addData('creditscorefactor',$cf);
      }
      // dd($arr,$crdId);
    }
    public function addTradelineSummary($arr){
      foreach ($arr as $key => $value) {
        $summary['user_id']=Session::get('reportUserId');
        $summary['source_type']=$this->getSourceType($key);
        $summary['TotalAccounts']=$value->TotalAccounts ?? 0;
        $summary['OpenAccounts']=$value->OpenAccounts ?? 0;
        $summary['CloseAccounts']=$value->CloseAccounts ?? 0;
        $summary['DelinquentAccounts']=$value->DelinquentAccounts ?? 0;
        $summary['DerogatoryAccounts']=$value->DerogatoryAccounts ?? 0;
        $summary['TotalBalances']=$value->TotalBalances ?? 0;
        $summary['TotalMonthlyPayments']=$value->TotalMonthlyPayments ?? 0;
        $summary['created']=date('Y-m-d H:i:s');
        $this->masterModel->addData('tradelinesummary',$summary);
        // dd($arr,$key,$value,$summary);
        
      }
    }
    public function addInquirySummary($arr){

    }
    public function addPublicRecordSummary($arr){
      
    }
    public function tradeLine($arr){
      // dd($arr->bureau);
      $trade['user_id']=Session::get('reportUserId');
      $trade['subscriberCode']=$arr->subscriberCode ?? '';
      $trade['highBalance']=$arr->highBalance ?? '';
      $trade['dateVerified']=$arr->dateVerified ?? '';
      $trade['dateReported']=$arr->dateReported ?? '';
      $trade['dateOpened']=$arr->dateOpened ?? '';
      $trade['accountNumber']=$arr->accountNumber ?? '';
      $trade['dateAccountStatus']=$arr->dateAccountStatus ?? '';
      $trade['currentBalance']=$arr->currentBalance ?? '';
      $trade['creditorName']=$arr->creditorName ?? '';
      $trade['position']=$arr->position ?? '';
      $trade['bureau']=$this->getSourceType($arr->bureau ??'');
      $trade['AccountCondition_abbreviation']=$arr->AccountCondition->abbreviation ?? '';
      $trade['AccountCondition_description']=$arr->AccountCondition->description ?? '';
      $trade['AccountCondition_symbol']=$arr->AccountCondition->symbol ?? '';
      $trade['AccountCondition_rank']=$arr->AccountCondition->rank ?? '';
      $trade['AccountDesignator_abbreviation']=$arr->AccountDesignator->abbreviation ?? '';
      $trade['AccountDesignator_description']=$arr->AccountDesignator->description ?? '';
      $trade['AccountDesignator_symbol']=$arr->AccountDesignator->symbol ?? '';
      $trade['AccountDesignator_rank']=$arr->AccountDesignator->rank ?? '';
      $trade['DisputeFlag_abbreviation']=$arr->DisputeFlag->abbreviation ?? '';
      $trade['DisputeFlag_description']=$arr->DisputeFlag->description ?? '';
      $trade['DisputeFlag_symbol']=$arr->DisputeFlag->symbol ?? '';
      $trade['DisputeFlag_rank']=$arr->DisputeFlag->rank ?? '';
      $trade['IndustryCode_abbreviation']=$arr->IndustryCode->abbreviation ?? '';
      $trade['IndustryCode_description']=$arr->IndustryCode->description ?? '';
      $trade['IndustryCode_symbol']=$arr->IndustryCode->symbol ?? '';
      $trade['IndustryCode_rank']=$arr->IndustryCode->rank ?? '';
      $trade['OpenClosed_abbreviation']=$arr->OpenClosed->abbreviation ?? '';
      $trade['OpenClosed_description']=$arr->OpenClosed->description ?? '';
      $trade['OpenClosed_symbol']=$arr->OpenClosed->symbol ?? '';
      $trade['OpenClosed_rank']=$arr->OpenClosed->rank ?? '';
      $trade['PayStatus_abbreviation']=$arr->PayStatus->abbreviation ?? '';
      $trade['PayStatus_description']=$arr->PayStatus->description ?? '';
      $trade['PayStatus_symbol']=$arr->PayStatus->symbol ?? '';
      $trade['PayStatus_rank']=$arr->PayStatus->rank ?? '';
      $trade['VerificationIndicator_abbreviation']=$arr->VerificationIndicator->abbreviation ?? '';
      $trade['VerificationIndicator_description']=$arr->VerificationIndicator->description ?? '';
      $trade['VerificationIndicator_symbol']=$arr->VerificationIndicator->symbol ?? '';
      $trade['VerificationIndicator_rank']=$arr->VerificationIndicator->rank ?? '';
      $trade['custom_remark']=$arr->Remark->customRemark ?? '';
      $trade['remark_abbreviation']=$arr->Remark->RemarkCode->abbreviation ?? '';
      $trade['remark_description']=$arr->Remark->RemarkCode->description ?? '';
      $trade['remark_symbol']=$arr->Remark->RemarkCode->symbol ?? '';
      $trade['remark_rank']=$arr->Remark->RemarkCode->rank ?? '';
      $trade['GrantedTrade_monthsReviewed']=$arr->GrantedTrade->monthsReviewed ?? '';
      $trade['GrantedTrade_monthlyPayment']=$arr->GrantedTrade->monthlyPayment ?? '';
      $trade['GrantedTrade_late90Count']=$arr->GrantedTrade->late90Count ?? '';
      $trade['GrantedTrade_late60Count']=$arr->GrantedTrade->late60Count ?? '';
      $trade['GrantedTrade_late30Count']=$arr->GrantedTrade->late30Count ?? '';
      $trade['GrantedTrade_termMonths']=$arr->GrantedTrade->termMonths ?? '';
      $trade['GrantedTrade_collateral']=$arr->GrantedTrade->collateral ?? '';
      $trade['GrantedTrade_amountPastDue']=$arr->GrantedTrade->amountPastDue ?? '';
      $trade['GrantedTrade_worstPatStatusCount']=$arr->GrantedTrade->worstPatStatusCount ?? '';
      $trade['AccountType_abbreviation']=$arr->GrantedTrade->worstPatStatusCount ?? '';
      $trade['AccountType_description']=$arr->GrantedTrade->AccountType->abbreviation ?? '';
      $trade['AccountType_symbol']=$arr->GrantedTrade->AccountType->description ?? '';
      $trade['AccountType_rank']=$arr->GrantedTrade->AccountType->rank ?? '';
      $trade['CreditType_abbreviation']=$arr->GrantedTrade->CreditType->abbreviation ?? '';
      $trade['CreditType_description']=$arr->GrantedTrade->CreditType->description ?? '';
      $trade['CreditType_symbol']=$arr->GrantedTrade->CreditType->symbol ?? '';
      $trade['CreditType_rank']=$arr->GrantedTrade->CreditType->rank ?? '';
      $trade['PaymentFrequency_abbreviation']=$arr->GrantedTrade->PaymentFrequency->abbreviation ?? '';
      $trade['PaymentFrequency_description']=$arr->GrantedTrade->PaymentFrequency->description ?? '';
      $trade['PaymentFrequency_symbol']=$arr->GrantedTrade->PaymentFrequency->symbol ?? '';
      $trade['PaymentFrequency_rank']=$arr->GrantedTrade->PaymentFrequency->rank ?? '';
      $trade['TermType_abbreviation']=$arr->GrantedTrade->TermType->abbreviation ?? '';
      $trade['TermType_description']=$arr->GrantedTrade->TermType->description ?? '';
      $trade['TermType_symbol']=$arr->GrantedTrade->TermType->symbol ?? '';
      $trade['TermType_rank']=$arr->GrantedTrade->TermType->rank ?? '';
      $trade['WorstPayStatus_abbreviation']=$arr->GrantedTrade->WorstPayStatus->abbreviation ?? '';
      $trade['WorstPayStatus_description']=$arr->GrantedTrade->WorstPayStatus->description ?? '';
      $trade['WorstPayStatus_symbol']=$arr->GrantedTrade->WorstPayStatus->symbol ?? '';
      $trade['WorstPayStatus_rank']=$arr->GrantedTrade->WorstPayStatus->rank ?? '';
      $trade['PayStatusHistory_abbreviation']=$arr->GrantedTrade->PayStatusHistory->abbreviation ?? '';
      $trade['PayStatusHistory_description']=$arr->GrantedTrade->PayStatusHistory->description ?? '';
      $trade['PayStatusHistory_symbol']=$arr->GrantedTrade->PayStatusHistory->symbol ?? '';
      $trade['PayStatusHistory_rank']=$arr->GrantedTrade->PayStatusHistory->rank ?? '';
      $trade['GrantedTrade_CreditLimit']=$arr->GrantedTrade->CreditLimit ?? 0;
      // $trade['status']=$arr->subscriberCode ?? '';
      $trade['created']=date('Y-m-d H:i:s');
      $this->masterModel->addData('transactions',$trade);
      
    }
    public function getSourceType($val){
      $sType=0;
      if($val=='TransUnion'){
          $sType=1;
        }else if($val=='Equifax'){
          $sType=2;
        }else if($val=='Experian'){
          $sType=3;
        }
        return $sType;
    }
    public function mfcnLogin(){
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => "http://clone.myfreescorenow.com/api/auth/login",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => array('email' => 'api@user.com','password' => 'mfsn12345'),
          
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $res=json_decode($response,true);
        if($res['success']==true){
        	return $res['data']['token'];
        }else{
        	return '';
        }
        dd($res['success']);
    }
    public function refreshThreeBReport($token)
    {
      $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => "http://clone.myfreescorenow.com/api/auth/refreshThreeBReport",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => array('username' => 'mfsnrep@gmail.com','password' => 'wordpass'),
          CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer ".$token
          ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $res=json_decode($response,true);
        // dd( json_decode($response,true));
        if($res['success']==true){
          return json_decode($res['data']);
        }else{
          return '';
        }
        echo $response;
    }
    public function getThreeBReport($token){
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => "http://clone.myfreescorenow.com/api/getThreeBureauReports",
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => "",
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => "POST",
          CURLOPT_POSTFIELDS => array('token' => 'bXlAM2IzMjFyZXBvcnRzITIwe21mfSNzIW4yMA==','username' => 'mfsnrep@gmail.com','password' => 'wordpass'),
          CURLOPT_HTTPHEADER => array(
		    "Authorization: Bearer ".$token
		  ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $res=json_decode($response,true);
        // dd( json_decode($response,true));
        if($res['success']==true){
        	return json_decode($res['data']);
        }else{
        	return '';
        }
        dd( json_decode($res['data']));

    }

    public function getSCreport(){
      return file_get_contents("https://www.smartcredit.com/member/credit-report/3b/simple.htm?format=JSON ");
    }
}