<?php

namespace App\Http\Controllers;

use App\Http\Requests;

use Illuminate\Http\Request;

use DB;

use Carbon\Carbon;

use Session;

use Hash;





class CreditController extends Controller
{

    /**

     * Create a new controller instance.

     *

     * @return void

     */

    public function __construct()
    {
        parent::__construct($this->masterModel);
    }

    public function index()
    { 
        $data = [];$res = [];Session::put('disputeSource',1);
        $data = $this->masterModel->getAllData('transactions',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>1]);
        foreach ($data as $key => $value) {
            $value->dispute_letter = DB::table('dispute_letters')->where(['user_id'=>$value->user_id,'transaction_id'=>$value->trans_id,'bureau'=>$value->bureau])->orderBy('round','desc')->first();
            $value->disputeData = $this->masterModel->customequery('select dispute_letters.*,dispute_reasons.custom as reason,dispute_master_reasons.subject from dispute_letters left join dispute_reasons on dispute_letters.id = dispute_reasons.dispute_id left join dispute_master_reasons on dispute_reasons.dispute_reason_id = dispute_master_reasons.id where dispute_letters.user_id = '.$value->user_id.' and dispute_letters.transaction_id = '.$value->trans_id.' and dispute_letters.bureau = '.$value->bureau);
           $res[]=$value;
        }
        $data['data'] = $res;
        // dd($res);
    	return view('frontend.credit',$data);
    }

    public function getAccountSummary(Request $request)
    {
        // dd($request->all());
        $where = '';
        $abbr = [];
        $smb = [];
        $dispute = [];
        foreach($request['status'] as $val)
        {
            if($val=='Positive'){
                $abbr[] = 'Open';
                $smb[] = 'O';
            }
            if($val=='Negative'){
                $abbr[] = 'Derog';
                $smb[] = 'F';
            }            
        }

        $data = DB::table('transactions')->where(['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau' =>$request['id']]);
        if($abbr!=[] && $smb!=[]){
            $data->whereIn('AccountCondition_abbreviation',$abbr);
            $data->whereIn('AccountCondition_symbol',$smb);
        }

        $getData=$data->get();
        $res = [];

        foreach ($getData as $key => $value) {
            $value->dispute_letter = DB::table('dispute_letters')->where(['user_id'=>$value->user_id,'transaction_id'=>$value->trans_id,'bureau'=>$value->bureau])->orderBy('round','desc')->first();
            $value->disputeData = $this->masterModel->customequery('select dispute_letters.*,dispute_reasons.custom as reason,dispute_master_reasons.subject from dispute_letters left join dispute_reasons on dispute_letters.id = dispute_reasons.dispute_id left join dispute_master_reasons on dispute_reasons.dispute_reason_id = dispute_master_reasons.id where dispute_letters.user_id = '.$value->user_id.' and dispute_letters.transaction_id = '.$value->trans_id.' and dispute_letters.bureau = '.$value->bureau);

           if($value->dispute_letter!=null && in_array($value->dispute_letter->status, $request['dispute']))
           {
                $res[]=$value; 
           }
           else if(in_array('true', $request['dispute']))
           {
                $res[]=$value;
           } 
        }
        // dd($res);
        return json_encode($res);
    }

    public function create_dispute()
    {
        $data['transId'] = $_GET['disputeId'] ?? 0;
        $data['dispute_letter'] = $this->masterModel->getSingleDataFirst('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>Session::get('disputeSource')],'created','desc');
        $data['data'] = $this->masterModel->getAllData('transactions',['user_id'=>Session::get('userLoginInfo')['user_id'],'bureau'=>Session::get('disputeSource'),'AccountCondition_abbreviation'=>'Derog','AccountCondition_symbol'=>'F']);
       
        return view('frontend.createDispute',$data);
    } 

    public function setDisputeSession($id)
    {
        Session::put('disputeSource',$id);
    }

    public function getDisputeReasons($id)
    {
        $data['dr'] = $this->masterModel->getAllData('dispute_master_reasons',['status'=>1]);
        $data['disp']='';
        if($id!=0)
        {
            $data['disp']=DB::table('dispute_reasons')->where('dispute_id',$id)->orderBy('id','desc')->get()->first();
        }
        $data['reason']=DB::table('dispute_reasons')->select('dispute_reasons.*','dispute_letters.bureau')->leftjoin('dispute_letters','dispute_reasons.dispute_id','=','dispute_letters.id')->where('dispute_letters.user_id',Session::get('userLoginInfo')['user_id'])->get();
        return json_encode($data);
    }

    public function saveDisputeReason(Request $request)
    {
        $account = $this->masterModel->getSingleCol('transactions','accountNumber',['trans_id'=>$request['trans_id']]);
        if($request['disId']!=0)
        {
            $data = $this->masterModel->updateData('dispute_reasons',['dispute_id'=>$request['disId']],['dispute_reason_id'=>$request['selectedValue'],'custom'=>$request['DisputeText']]);
            $dislet = $this->masterModel->getSingleData('dispute_letters',['id'=>$request['disId']]);
        }
        else
        {
            $round = $this->masterModel->getCount('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'transaction_id'=>$request['trans_id'],'bureau'=>$request['bureau']]);
            $round = $round + 1;
            $id = $this->masterModel->addDataGetID('dispute_letters',['user_id'=>Session::get('userLoginInfo')['user_id'],'transaction_id'=>$request['trans_id'],'bureau'=>$request['bureau'],'round'=>$round,'acc_no'=>$account,'status'=>1,'created'=>date('Y-m-d H:i:s')]);
            $data = $this->masterModel->addData('dispute_reasons',['dispute_id'=>$id,'dispute_reason_id'=>$request['selectedValue'],'custom'=>$request['DisputeText'],'status'=>1,'created'=>date('Y-m-d H:i:s')]);
            $dislet = $this->masterModel->getSingleData('dispute_letters',['id'=>$id]);
        }
        
        return json_encode($dislet);
    }

}

